/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;

public class TicketMachine {
    HashMap<Object, List<Ticket>> tickets = new HashMap();

    public IPromise<IPromise> getTicket(final Object channelKey) {
        List<Ticket> futures = this.tickets.get(channelKey);
        if (futures == null) {
            futures = new ArrayList<Ticket>(3);
            this.tickets.put(channelKey, futures);
        }
        Promise signalFin = new Promise();
        Promise<IPromise> signalStart = new Promise<IPromise>();
        final Ticket ticket = new Ticket(signalStart, signalFin);
        futures.add(ticket);
        final List<Ticket> finalFutures = futures;
        signalFin.then(new Callback(){

            public void complete(Object result, Object error) {
                boolean remove = finalFutures.remove(ticket);
                if (!remove) {
                    System.err.println("Error failed to remove " + channelKey);
                }
                TicketMachine.this.checkNext(channelKey, finalFutures, ticket);
            }
        });
        if (futures.size() == 1) {
            signalStart.complete(signalFin, null);
        }
        return signalStart;
    }

    private void checkNext(Object channelKey, List<Ticket> futures, Ticket ticket) {
        if (futures.size() == 0) {
            this.tickets.remove(channelKey);
        } else {
            Ticket nextTicket = futures.get(0);
            nextTicket.signalProcessingStart.complete(nextTicket.signalProcessingFinished, null);
        }
    }

    public HashMap<Object, List<Ticket>> getTickets() {
        return this.tickets;
    }

    static class Ticket {
        IPromise signalProcessingStart;
        IPromise signalProcessingFinished;

        Ticket(IPromise signalProcessingStart, IPromise signalProcessingFinished) {
            this.signalProcessingStart = signalProcessingStart;
            this.signalProcessingFinished = signalProcessingFinished;
        }
    }
}

