/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.encoding;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.remoting.base.ConnectionRegistry;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.kontraktor.remoting.base.RemotedCallback;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.util.FSTUtil;

public class CallbackRefSerializer
extends FSTBasicObjectSerializer {
    ConnectionRegistry reg;

    public CallbackRefSerializer(ConnectionRegistry reg) {
        this.reg = reg;
    }

    public void readObject(FSTObjectInput in, Object toRead, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy) throws Exception {
    }

    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws Exception {
        long id = in.readLong();
        AtomicReference<ObjectSocket> chan = this.reg.getWriteObjectSocket();
        MyRemotedCallback cb = new MyRemotedCallback(chan, id);
        in.registerObject((Object)cb, streamPositioin, serializationInfo, referencee);
        return cb;
    }

    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        long id = this.reg.registerPublishedCallback((Callback)toWrite);
        out.writeLong(id);
    }

    public class MyRemotedCallback
    implements Callback,
    RemotedCallback {
        AtomicReference<ObjectSocket> chan;
        long id;

        public MyRemotedCallback(AtomicReference<ObjectSocket> chan, long id) {
            this.chan = chan;
            this.id = id;
        }

        public int getChanId() {
            return this.chan.get().getId();
        }

        public long getId() {
            return this.id;
        }

        public void complete(Object result, Object error) {
            try {
                CallbackRefSerializer.this.reg.receiveCBResult(this.chan.get(), this.id, result, error);
            }
            catch (Exception e) {
                Log.Warn(this, e, "");
                FSTUtil.rethrow((Throwable)e);
            }
        }

        @Override
        public boolean isTerminated() {
            boolean terminated = CallbackRefSerializer.this.reg.isTerminated();
            if (terminated) {
                return true;
            }
            boolean closed = this.chan.get().isClosed();
            if (closed) {
                Log.Error((Object)this, "registry alive, but socket closed");
            }
            return closed;
        }
    }
}

