/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.base;

import java.io.IOError;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.impl.BackOffStrategy;
import org.nustaq.kontraktor.remoting.base.ConnectionRegistry;
import org.nustaq.kontraktor.util.Log;

public class RemoteRefPolling
implements Runnable {
    public static long EMPTY_Q_BACKOFF_WAIT_MILLIS = BackOffStrategy.SLEEP_NANOS / 1000 / 1000;
    public static long NONE_CONNETCED_WAIT_MILLIS = 100L;
    ArrayList<ScheduleEntry> sendJobs = new ArrayList();
    AtomicInteger instanceCount = new AtomicInteger(0);
    boolean loopStarted = false;
    boolean underway = false;
    Thread pollThread;
    int remoteRefCounter = 0;

    public RemoteRefPolling() {
        this.instanceCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPromise scheduleSendLoop(ConnectionRegistry reg) {
        Promise promise = new Promise();
        this.sendJobs.add(new ScheduleEntry(reg, promise));
        RemoteRefPolling remoteRefPolling = this;
        synchronized (remoteRefPolling) {
            if (!this.loopStarted) {
                this.loopStarted = true;
                Actor.current().execute(this);
            }
        }
        return promise;
    }

    @Override
    public void run() {
        this.pollThread = Thread.currentThread();
        if (this.underway) {
            return;
        }
        this.underway = true;
        try {
            int count = 1;
            while (count > 0) {
                count = this.onePoll();
                if (this.sendJobs.size() > 0) {
                    if (count > 0) {
                        boolean bl = true;
                        continue;
                    }
                    if (this.remoteRefCounter == 0) {
                        Actor.current().delayed(NONE_CONNETCED_WAIT_MILLIS, this);
                        continue;
                    }
                    Actor.current().delayed(EMPTY_Q_BACKOFF_WAIT_MILLIS, this);
                    continue;
                }
                Actor.current().delayed(NONE_CONNETCED_WAIT_MILLIS, this);
            }
        }
        finally {
            this.underway = false;
        }
    }

    protected int onePoll() {
        int count = 1;
        int maxit = 1;
        this.remoteRefCounter = 0;
        count = 0;
        for (int i = 0; i < this.sendJobs.size(); ++i) {
            ScheduleEntry entry = this.sendJobs.get(i);
            if (entry.reg.getRemoteActorSize() > 0) {
                ++this.remoteRefCounter;
            }
            if (entry.reg.isTerminated()) {
                this.terminateEntry(i, entry, "terminated", null);
                --i;
                continue;
            }
            try {
                if (!entry.reg.pollAndSend2Remote(entry.reg.getWriteObjectSocket())) continue;
                ++count;
                continue;
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() != null) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                Log.Error((Object)this, e);
                if (!(e instanceof IOException) && !(e instanceof IOError)) continue;
                this.terminateEntry(i, entry, null, e);
                --i;
            }
        }
        --maxit;
        return count;
    }

    protected void terminateEntry(int i, ScheduleEntry entry, Object res, Throwable e) {
        entry.reg.stopRemoteRefs();
        this.sendJobs.remove(i);
        entry.promise.complete(res, e);
    }

    public static class ScheduleEntry {
        ConnectionRegistry reg;
        IPromise promise;

        public ScheduleEntry(ConnectionRegistry reg, Promise promise) {
            this.reg = reg;
            this.promise = promise;
        }
    }
}

