/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.routers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.remoting.base.ConnectionRegistry;
import org.nustaq.kontraktor.remoting.encoding.RemoteCallEntry;
import org.nustaq.kontraktor.routers.AbstractKrouter;
import org.nustaq.kontraktor.util.Log;

public class HotHotFailoverKrouter<T extends HotHotFailoverKrouter>
extends AbstractKrouter<T> {
    ArrayList<Actor> remoteServices;

    @Override
    public void init() {
        this.remoteServices = new ArrayList();
        super.init();
    }

    @Override
    public IPromise router$RegisterService(Actor remoteRef, boolean stateful) {
        super.router$RegisterService(remoteRef, stateful);
        ArrayList<Actor> services = new ArrayList<Actor>();
        services.add(remoteRef);
        services.addAll(this.remoteServices);
        this.remoteServices = services;
        Log.Info((Object)this, "service registered " + remoteRef);
        return HotHotFailoverKrouter.resolve();
    }

    @Override
    @Local
    public void router$handleServiceDisconnect(Actor x) {
        boolean remove = this.remoteServices.remove(x.getActor());
        if (!remove) {
            remove = this.remoteServices.remove(x.getActorRef());
        }
        if (remove) {
            Log.Info((Object)this, "removed service " + x);
        }
    }

    @Override
    protected List<Actor> getServices() {
        ArrayList<Actor> svs = new ArrayList<Actor>();
        if (this.remoteServices != null) {
            svs.addAll(this.remoteServices);
        }
        return svs;
    }

    @Override
    @CallerSideMethod
    protected boolean dispatchRemoteCall(RemoteCallEntry rce, ConnectionRegistry clientRemoteRegistry) {
        if (((HotHotFailoverKrouter)this.getActor()).remoteServices.size() == 0) {
            return false;
        }
        boolean[] done = new boolean[]{false};
        Callback[] selected = new Callback[]{null};
        this.dispatchImpl(rce, clientRemoteRegistry, done, selected);
        return true;
    }

    @CallerSideMethod
    protected void dispatchImpl(RemoteCallEntry rce, ConnectionRegistry clientRemoteRegistry, boolean[] done, Callback[] selected) {
        ((HotHotFailoverKrouter)this.getActor()).remoteServices.forEach((Consumer<Actor>)((Consumer<Object>)service -> this.forwardMultiCall(rce, (Actor)service, clientRemoteRegistry, done, selected)));
    }
}

