/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.base;

import java.util.concurrent.TimeUnit;
import org.nustaq.kontraktor.annotations.RateLimited;
import org.nustaq.kontraktor.util.Log;

public class RateLimitEntry {
    public static final long REJECT = -1L;
    private final RateLimited rateLimit;
    private final long interval;
    int count;
    long lastCheck;

    public RateLimitEntry(RateLimited rateLimited) {
        this.rateLimit = rateLimited;
        this.interval = rateLimited.callsPerMinute() != 0 ? TimeUnit.MINUTES.toMillis(1L) : 1000L;
    }

    public long registerCall(long now, String methodName) {
        ++this.count;
        if (this.lastCheck == 0L) {
            this.lastCheck = now;
        } else if (now - this.lastCheck > this.interval) {
            this.count = 0;
            this.lastCheck = now;
        } else {
            int maxCount;
            int n = maxCount = this.rateLimit.callsPerMinute() > 0 ? this.rateLimit.callsPerMinute() : this.rateLimit.callsPerSecond();
            if (this.count >= maxCount) {
                Log.Warn((Object)this, "Ratelimit hit on " + methodName);
                return -1L;
            }
        }
        return 0L;
    }
}

