/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.Promise;

public class SubscriptionSupport {
    private Map<Integer, Callback> subsMap = new HashMap<Integer, Callback>();

    public Promise<Integer> createSubsId() {
        int id = (int)(Math.random() * 2.147483647E9);
        if (this.getSubsMap().containsKey(id)) {
            return this.createSubsId();
        }
        this.getSubsMap().put(id, new DummyCB());
        return new Promise<Integer>(id);
    }

    public Promise<Boolean> subscribe(int id, Callback cb) {
        if (!(this.getSubsMap().get(id) instanceof DummyCB)) {
            return new Promise<Boolean>(false);
        }
        this.getSubsMap().put(id, cb);
        return new Promise<Boolean>(true);
    }

    public Promise<Boolean> unSubscribe(int id, Callback cb) {
        Callback removed = this.getSubsMap().remove(id);
        if (removed != null) {
            removed.finish();
        }
        return new Promise<Boolean>(removed != null);
    }

    public void cleanUp() {
        Iterator<Map.Entry<Integer, Callback>> it = this.getSubsMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Callback> next = it.next();
            if (!next.getValue().isTerminated()) continue;
            it.remove();
        }
    }

    protected Map<Integer, Callback> getSubsMap() {
        return this.subsMap;
    }

    static class DummyCB
    implements Callback {
        protected long timeStamp = System.currentTimeMillis();

        public void complete(Object result, Object error) {
        }

        @Override
        public boolean isTerminated() {
            return System.currentTimeMillis() - this.timeStamp > 10000L;
        }
    }
}

