/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.routers;

import java.util.ArrayList;
import java.util.List;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.remoting.base.ConnectionRegistry;
import org.nustaq.kontraktor.remoting.encoding.RemoteCallEntry;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.tcp.TCPNIOPublisher;
import org.nustaq.kontraktor.routers.AbstractKrouter;
import org.nustaq.kontraktor.routers.KrouterRemoteConUserData;
import org.nustaq.kontraktor.routers.Routing;
import org.nustaq.kontraktor.util.Log;

public abstract class SingleActiveServiceKrouter<T extends SingleActiveServiceKrouter>
extends AbstractKrouter<T> {
    @CallerSideMethod
    protected abstract Actor getRemoteRef();

    @CallerSideMethod
    protected abstract void setRemoteRef(Actor var1);

    @Override
    public IPromise router$RegisterService(Actor remoteRef, boolean stateful) {
        super.router$RegisterService(remoteRef, stateful);
        this.setRemoteRef(remoteRef);
        return SingleActiveServiceKrouter.resolve();
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    @Local
    public abstract void router$handleServiceDisconnect(Actor var1);

    @Override
    protected List<Actor> getServices() {
        ArrayList<Actor> svs = new ArrayList<Actor>();
        if (this.getRemoteRef() != null) {
            svs.add(this.getRemoteRef());
        }
        return svs;
    }

    @Override
    @CallerSideMethod
    protected boolean dispatchRemoteCall(RemoteCallEntry rce, ConnectionRegistry clientRemoteRegistry) {
        KrouterRemoteConUserData ud = null;
        if (this.isStateful()) {
            if (clientRemoteRegistry.userData.get() == null) {
                clientRemoteRegistry.userData.set(new KrouterRemoteConUserData());
            }
            ud = (KrouterRemoteConUserData)clientRemoteRegistry.userData.get();
            if (ud.lastRoutedService != null) {
                boolean published = ud.lastRoutedService.isPublished();
                boolean stopped = ud.lastRoutedService.isStopped();
                if (!stopped) {
                    this.forwardCall(rce, ud.lastRoutedService, clientRemoteRegistry);
                    return true;
                }
                clientRemoteRegistry.userData.set(null);
                this.sendFailoverNotification(clientRemoteRegistry);
            }
        }
        if (this.getRemoteRef() == null) {
            Log.Warn((Object)this, "unhandled call, service has disconnected");
            return false;
        }
        if (ud != null) {
            ud.lastRoutedService = this.getRemoteRef();
        }
        this.willDispatch();
        this.forwardCall(rce, this.getRemoteRef(), clientRemoteRegistry);
        return true;
    }

    @CallerSideMethod
    protected void willDispatch() {
    }

    public static void main(String[] args) {
        Routing.start(SingleActiveServiceKrouter.class, new TCPNIOPublisher().port(6667).serType(SerializerType.JsonNoRef));
    }
}

