/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.tcp;

import java.util.function.Consumer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.impl.SimpleScheduler;
import org.nustaq.kontraktor.remoting.base.ActorClient;
import org.nustaq.kontraktor.remoting.base.ActorClientConnector;
import org.nustaq.kontraktor.remoting.base.ConnectableActor;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.tcp.TCPClientConnector;

public class TCPConnectable
implements ConnectableActor {
    String host;
    int port;
    Class actorClz;
    Coding coding = new Coding(SerializerType.FSTSer);
    int inboundQueueSize = SimpleScheduler.DEFQSIZE;

    public TCPConnectable() {
    }

    public TCPConnectable(Class actorClz, String host, int port) {
        this.host = host;
        this.port = port;
        this.actorClz = actorClz;
    }

    @Override
    public <T extends Actor> IPromise<T> connect(Callback<ActorClientConnector> disconnectCallback, Consumer<Actor> actorDisconnecCB) {
        if (this.actorClz == null) {
            throw new RuntimeException("actor class cannot be null on TCPConnectable");
        }
        if (this.host == null) {
            throw new RuntimeException("host cannot be null on TCPConnectable");
        }
        Promise result = new Promise();
        Runnable connect = () -> {
            TCPClientConnector client = new TCPClientConnector(this.port, this.host, disconnectCallback);
            ActorClient connector = new ActorClient(client, this.actorClz, this.coding);
            connector.connect(this.inboundQueueSize, actorDisconnecCB).then(result);
        };
        if (!Actor.inside()) {
            TCPClientConnector.get().execute(() -> Thread.currentThread().setName("tcp singleton remote client actor polling"));
            TCPClientConnector.get().execute(connect);
        } else {
            connect.run();
        }
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Class getActorClz() {
        return this.actorClz;
    }

    public TCPConnectable host(String host) {
        this.host = host;
        return this;
    }

    public TCPConnectable port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public TCPConnectable actorClass(Class actorClz) {
        this.actorClz = actorClz;
        return this;
    }

    @Override
    public Class<? extends Actor> getActorClass() {
        return this.actorClz;
    }

    public TCPConnectable coding(Coding coding) {
        this.coding = coding;
        return this;
    }

    public TCPConnectable serType(SerializerType sertype) {
        this.coding = new Coding(sertype);
        return this;
    }

    @Override
    public TCPConnectable inboundQueueSize(int inboundQueueSize) {
        this.inboundQueueSize = inboundQueueSize;
        return this;
    }

    public String toString() {
        return "TCPConnectable{host='" + this.host + '\'' + ", port=" + this.port + ", actorClz=" + this.actorClz + ", coding=" + this.coding + ", inboundQueueSize=" + this.inboundQueueSize + '}';
    }
}

