/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Scheduler;
import org.nustaq.kontraktor.impl.ActorProxyFactory;
import org.nustaq.kontraktor.impl.DispatcherThread;
import org.nustaq.serialization.util.FSTUtil;

public class ActorsImpl {
    protected ConcurrentLinkedQueue deadLetters = new ConcurrentLinkedQueue();
    protected ActorProxyFactory factory = new ActorProxyFactory();

    public ActorProxyFactory getFactory() {
        return this.factory;
    }

    public ConcurrentLinkedQueue getDeadLetters() {
        return this.deadLetters;
    }

    public Actor makeProxy(Class<? extends Actor> clz, DispatcherThread disp, int qs) {
        try {
            return this.makeProxy(clz.newInstance(), clz, disp, qs);
        }
        catch (Exception e) {
            FSTUtil.rethrow((Throwable)e);
            return null;
        }
    }

    public Actor makeProxy(Actor realActor, Class<? extends Actor> clz, DispatcherThread disp, int qs) {
        try {
            Actor selfproxy;
            if (realActor == null) {
                if (Modifier.isAbstract(clz.getModifiers())) {
                    realActor = (Actor)this.getFactory().instantiateProxy(clz, realActor);
                    Field target = realActor.getClass().getField("__target");
                    target.setAccessible(true);
                    target.set(realActor, realActor);
                } else {
                    realActor = clz.newInstance();
                }
            }
            if (qs <= 100) {
                qs = disp.getScheduler().getDefaultQSize();
            }
            qs = FSTUtil.nextPow2((int)qs);
            realActor.__mailbox = this.createQueue(qs);
            realActor.__mbCapacity = realActor.__mailboxCapacity = qs;
            realActor.__cbQueue = this.createQueue(qs);
            realActor.__self = selfproxy = (Actor)this.getFactory().instantiateProxy(clz, realActor);
            selfproxy.__self = selfproxy;
            selfproxy.__mailbox = realActor.__mailbox;
            selfproxy.__mailboxCapacity = qs;
            selfproxy.__mbCapacity = realActor.__mbCapacity;
            selfproxy.__cbQueue = realActor.__cbQueue;
            realActor.__scheduler = disp.getScheduler();
            selfproxy.__scheduler = disp.getScheduler();
            realActor.__currentDispatcher = disp;
            selfproxy.__currentDispatcher = disp;
            disp.addActor(realActor);
            return selfproxy;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public Queue createQueue(int qSize) {
        return new ConcurrentArrayQueue(Math.max(512, qSize / 10));
    }

    public Actor newProxy(Class<? extends Actor> clz, Scheduler sched, int qsize) {
        return this.newProxy(null, clz, sched, qsize);
    }

    public Actor newProxy(Actor instance, Class<? extends Actor> clz, Scheduler sched, int qsize) {
        if (sched == null && Thread.currentThread() instanceof DispatcherThread) {
            sched = ((DispatcherThread)Thread.currentThread()).getScheduler();
        }
        try {
            if (sched == null) {
                sched = Actors.defaultScheduler.get();
            }
            if (qsize < 1) {
                qsize = sched.getDefaultQSize();
            }
            return this.makeProxy(instance, clz, sched.assignDispatcher(70), qsize);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

