/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.impl;

import java.io.Externalizable;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassMap;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Loader;
import javassist.Modifier;
import javassist.NotFoundException;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.ActorProxy;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.annotations.AsCallback;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.impl.ClassPathProvider;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.serialization.util.FSTUtil;

public class ActorProxyFactory {
    Map<Class, Class> generatedProxyClasses = new HashMap<Class, Class>();

    public <T> T instantiateProxy(Actor target) {
        Class<?> targetClass = target.getClass();
        return this.instantiateProxy(targetClass, target);
    }

    public <T> T instantiateProxy(Class<? extends Actor> targetClass, Actor target) {
        try {
            Object instance;
            block9: {
                if (!Modifier.isPublic((int)targetClass.getModifiers())) {
                    throw new RuntimeException("Actor class must be public:" + targetClass.getName());
                }
                if (targetClass.isAnonymousClass()) {
                    throw new RuntimeException("Anonymous classes can't be Actors:" + targetClass.getName());
                }
                if (targetClass.isMemberClass() && !Modifier.isStatic((int)targetClass.getModifiers())) {
                    throw new RuntimeException("Only STATIC inner classes can be Actors:" + targetClass.getName());
                }
                Class<? extends Actor> proxyClass = this.createProxyClass(targetClass, targetClass.getClassLoader());
                Constructor<?>[] constructors = proxyClass.getConstructors();
                instance = null;
                try {
                    instance = FSTUtil.unFlaggedUnsafe != null ? FSTUtil.unFlaggedUnsafe.allocateInstance(proxyClass) : proxyClass.newInstance();
                }
                catch (Exception e) {
                    for (int i = 0; i < constructors.length; ++i) {
                        Constructor<?> constructor = constructors[i];
                        if (constructor.getParameterTypes().length == 0) {
                            constructor.setAccessible(true);
                            instance = constructor.newInstance(new Object[0]);
                            break;
                        }
                        if (constructor.getParameterTypes().length != 1) continue;
                        instance = constructor.newInstance(new Object[]{null});
                        break;
                    }
                    if (instance != null) break block9;
                    throw e;
                }
            }
            Field f = instance.getClass().getField("__target");
            f.setAccessible(true);
            f.set(instance, target);
            return (T)instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Class<T> createProxyClass(Class<T> clazz, ClassLoader loader) throws Exception {
        Map<Class, Class> map = this.generatedProxyClasses;
        synchronized (map) {
            String proxyName = clazz.getName() + "_ActorProxy";
            Class ccClz = this.generatedProxyClasses.get(clazz);
            if (ccClz == null) {
                ClassPool pool = ClassPool.getDefault();
                if (loader instanceof ClassPathProvider) {
                    ClassPool local = new ClassPool(pool);
                    List<File> classPath = ((ClassPathProvider)((Object)loader)).getClassPath();
                    for (int i = 0; i < classPath.size(); ++i) {
                        File file = classPath.get(i);
                        local.appendClassPath(file.getAbsolutePath());
                    }
                    pool = local;
                }
                CtClass cc = null;
                try {
                    cc = pool.getCtClass(proxyName);
                }
                catch (NotFoundException classPath) {
                    // empty catch block
                }
                if (cc == null) {
                    CtClass orig;
                    block11: {
                        cc = pool.makeClass(proxyName);
                        try {
                            orig = pool.get(clazz.getName());
                        }
                        catch (NotFoundException ex) {
                            pool.insertClassPath((ClassPath)new ClassClassPath(clazz));
                            orig = pool.get(clazz.getName());
                            if (orig != null) break block11;
                            throw ex;
                        }
                    }
                    cc.setSuperclass(orig);
                    cc.setInterfaces(new CtClass[]{pool.get(Externalizable.class.getName()), pool.get(ActorProxy.class.getName())});
                    this.defineProxyFields(pool, cc);
                    this.defineProxyMethods(cc, orig);
                }
                ccClz = this.loadProxyClass(clazz, pool, cc);
                this.generatedProxyClasses.put(clazz, ccClz);
            }
            return ccClz;
        }
    }

    protected <T> Class loadProxyClass(Class clazz, ClassPool pool, final CtClass cc) throws ClassNotFoundException {
        Loader cl = new Loader(clazz.getClassLoader(), pool){

            protected Class loadClassByDelegation(String name) throws ClassNotFoundException {
                if (name.equals(cc.getName())) {
                    return null;
                }
                return this.delegateToParent(name);
            }
        };
        Class ccClz = cl.loadClass(cc.getName());
        return ccClz;
    }

    protected void defineProxyFields(ClassPool pool, CtClass cc) throws CannotCompileException, NotFoundException {
        CtField target = new CtField(pool.get(cc.getSuperclass().getName()), "__target", cc);
        target.setModifiers(1);
        cc.addField(target);
    }

    protected void defineProxyMethods(CtClass cc, CtClass orig) throws Exception {
        CtMethod[] methods = ActorProxyFactory.getSortedPublicCtMethods(orig, false);
        for (int i = 0; i < methods.length; ++i) {
            boolean isCallerSide;
            ClassMap map;
            CtMethod method;
            CtMethod originalMethod = method = methods[i];
            if (method.getName().equals("getActor")) {
                map = new ClassMap();
                map.put(Actor.class.getName(), Actor.class.getName());
                method = CtMethod.make((String)("public " + Actor.class.getName() + " getActor() { return __target; }"), (CtClass)cc);
            } else {
                map = new ClassMap();
                map.fix(orig);
                map.fix(Actor.class.getName());
                method = new CtMethod(method, cc, map);
            }
            CtClass returnType = method.getReturnType();
            boolean bl = isCallerSide = originalMethod.getAnnotation(CallerSideMethod.class) != null || originalMethod.getName().equals("self");
            if (isCallerSide) {
                Object[][] availableParameterAnnotations = originalMethod.getAvailableParameterAnnotations();
                CtClass[] parameterTypes = originalMethod.getParameterTypes();
                for (int j = 0; j < availableParameterAnnotations.length; ++j) {
                    Object[] availableParameterAnnotation = availableParameterAnnotations[j];
                    if (availableParameterAnnotation.length <= 0) continue;
                    for (int k = 0; k < availableParameterAnnotation.length; ++k) {
                        Object annot = availableParameterAnnotation[k];
                        if (annot.toString().indexOf("kontraktor.annotations.InThread") <= 0) continue;
                        throw new RuntimeException("cannot combine @CallerSide and @InThread, manually wrap callback using inThread(). method:" + originalMethod + " clz:" + orig);
                    }
                }
            }
            boolean allowed = (method.getModifiers() & 0x400) == 0 && (method.getModifiers() & 0x118) == 0 && (method.getModifiers() & 1) != 0 && !isCallerSide;
            allowed &= !originalMethod.getDeclaringClass().getName().equals(Object.class.getName()) && !originalMethod.getDeclaringClass().getName().equals(Actor.class.getName());
            if (originalMethod.getName().equals("getSubMonitorables") || originalMethod.getName().equals("getReport") || originalMethod.getName().equals("askMsg") || originalMethod.getName().equals("tellMsg") || originalMethod.getName().equals("__unpublish") || originalMethod.getName().equals("__republished") || originalMethod.getName().equals("ping") || originalMethod.getName().equals("__submit") || originalMethod.getName().equals("exec") || originalMethod.getName().equals("asyncstop") || originalMethod.getName().equals("receive") || originalMethod.getName().equals("complete") || originalMethod.getName().equals("close")) {
                allowed = true;
            }
            if (allowed) {
                boolean isCallbackCall;
                boolean isVoid = returnType == CtPrimitiveType.voidType;
                boolean bl2 = isCallbackCall = originalMethod.getAnnotation(AsCallback.class) != null;
                if (returnType != CtPrimitiveType.voidType && !returnType.getName().equals(IPromise.class.getName())) {
                    throw new RuntimeException("only void methods or methods returning IPromise allowed problematic method:" + originalMethod);
                }
                String conversion = "";
                Object[][] availableParameterAnnotations = originalMethod.getAvailableParameterAnnotations();
                CtClass[] parameterTypes = originalMethod.getParameterTypes();
                block3: for (int j = 0; j < availableParameterAnnotations.length; ++j) {
                    Object[] availableParameterAnnotation = availableParameterAnnotations[j];
                    if (availableParameterAnnotation.length <= 0) continue;
                    for (int k = 0; k < availableParameterAnnotation.length; ++k) {
                        Object annot = availableParameterAnnotation[k];
                        if (annot.toString().indexOf("kontraktor.annotations.InThread") <= 0) continue;
                        if (parameterTypes[j].getName().equals(Callback.class.getName())) {
                            Log.Info((Object)this, "InThread unnecessary when using built in Callback class. method:" + originalMethod + " clz:" + orig);
                            continue;
                        }
                        if (!parameterTypes[j].isInterface()) {
                            throw new RuntimeException("@InThread can be used on interfaces only");
                        }
                        String an = Actor.class.getName();
                        conversion = conversion + an + " sender=(" + an + ")sender.get();";
                        conversion = conversion + "if ( sender != null ) { args[" + j + "] = sender.__scheduler.inThread(sender.__self, args[" + j + "]); }";
                        continue block3;
                    }
                }
                String call = "__target.__enqueueCall( this, \"" + method.getName() + "\", args, " + isCallbackCall + " );";
                if (!isVoid) {
                    call = "return (" + originalMethod.getReturnType().getName() + ") (Object)" + call;
                }
                String body = "{ Object args[] = $args;" + conversion + call + "}";
                method.setBody(body);
                cc.addMethod(method);
                continue;
            }
            if ((method.getModifiers() & 0x118) != 0 || isCallerSide || method.getName().equals("toString") || method.getName().equals("__stopImpl")) continue;
            if (!(method.getName().equals("getActor") || method.getName().equals("delayed") || method.getName().equals("exec"))) {
                method.setBody("throw new RuntimeException(\"can only call public methods on actor ref. method:'" + method.getName() + "\");");
                cc.addMethod(method);
                continue;
            }
            cc.addMethod(method);
        }
    }

    public String toString(Method m) {
        try {
            StringBuilder sb = new StringBuilder();
            int mod = m.getModifiers() & java.lang.reflect.Modifier.methodModifiers();
            if (mod != 0) {
                sb.append(java.lang.reflect.Modifier.toString(mod)).append(' ');
            }
            sb.append(m.getReturnType()).append(' ');
            sb.append(m.getName()).append('(');
            Class<?>[] params = m.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(params[j].toString());
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public static String toString(CtMethod m) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(m.getDeclaringClass().getName() + "::");
            sb.append(m.getReturnType().getName()).append(' ');
            sb.append(m.getName()).append('(');
            CtClass[] params = m.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(params[j].getName());
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    protected CtMethod[] getSortedNonPublicCtMethods(CtClass orig) throws NotFoundException {
        CtMethod method;
        int i;
        int count = 0;
        CtMethod[] methods0 = orig.getMethods();
        for (int i2 = methods0.length - 1; i2 >= 0; --i2) {
            CtMethod method2 = methods0[i2];
            if (method2.getDeclaringClass().isInterface()) continue;
            String str = ActorProxyFactory.toString(method2);
            boolean isVolatile = method2.toString().indexOf("volatile ") >= 0;
            boolean isStatic = Modifier.isStatic((int)method2.getModifiers());
            boolean isPublic = Modifier.isPublic((int)method2.getModifiers());
            if (!isPublic && !isVolatile && !isStatic && !method2.getName().startsWith("access$")) continue;
            methods0[i2] = null;
        }
        CtMethod[] methods = null;
        for (i = 0; i < methods0.length; ++i) {
            method = methods0[i];
            if (method == null) continue;
            ++count;
        }
        methods = new CtMethod[count];
        count = 0;
        for (i = 0; i < methods0.length; ++i) {
            method = methods0[i];
            if (method == null) continue;
            methods[count++] = method;
        }
        Arrays.sort(methods, (o1, o2) -> {
            try {
                return (o1.getName() + o1.getReturnType() + o1.getParameterTypes().length).compareTo(o2.getName() + o2.getReturnType() + o2.getParameterTypes().length);
            }
            catch (NotFoundException e) {
                e.printStackTrace();
                return 0;
            }
        });
        return methods;
    }

    public static CtMethod[] getSortedPublicCtMethods(CtClass orig, boolean onlyRemote) throws NotFoundException {
        CtMethod method;
        int count = 0;
        CtMethod[] methods0 = orig.getMethods();
        HashSet<String> alreadypresent = new HashSet<String>();
        HashSet<String> unqiqueForActors = new HashSet<String>();
        for (int i = methods0.length - 1; i >= 0; --i) {
            CtMethod method2 = methods0[i];
            if (method2.getDeclaringClass().isInterface() || (method2.getModifiers() & 1) == 0) continue;
            String str = ActorProxyFactory.toString(method2);
            boolean isVolatile = method2.toString().indexOf("volatile ") >= 0;
            boolean isStatic = Modifier.isStatic((int)method2.getModifiers());
            if (isVolatile || isStatic || alreadypresent.contains(str) || method2.getName().startsWith("access$")) {
                methods0[i] = null;
                continue;
            }
            String key = method2.getName();
            if (unqiqueForActors.contains(key) && !method2.getDeclaringClass().getName().equals("java.lang.Object")) {
                throw new RuntimeException("method overloading not supported for actors. problematic Method: " + key + " on class " + orig.getName());
            }
            unqiqueForActors.add(key);
            alreadypresent.add(str);
        }
        CtMethod[] methods = null;
        if (onlyRemote) {
            int i;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if (method == null || (method.getModifiers() & 1) == 0) continue;
                ++count;
            }
            methods = new CtMethod[count];
            count = 0;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if ((method.getModifiers() & 1) == 0) continue;
                methods[count++] = method;
            }
        } else {
            int i;
            count = 0;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if (method == null) continue;
                ++count;
            }
            methods = new CtMethod[count];
            count = 0;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if (method == null) continue;
                methods[count++] = method;
            }
        }
        Arrays.sort(methods, (o1, o2) -> {
            try {
                return (o1.getName() + o1.getReturnType() + o1.getParameterTypes().length).compareTo(o2.getName() + o2.getReturnType() + o2.getParameterTypes().length);
            }
            catch (NotFoundException e) {
                e.printStackTrace();
                return 0;
            }
        });
        return methods;
    }

    public static <A extends Annotation> A getInheritedAnnotation(Class<A> annotationClass, AnnotatedElement element) {
        A annotation = element.getAnnotation(annotationClass);
        if (annotation == null && element instanceof Method) {
            annotation = ActorProxyFactory.getOverriddenAnnotation(annotationClass, (Method)element);
        }
        return annotation;
    }

    private static <A extends Annotation> A getOverriddenAnnotation(Class<A> annotationClass, Method method) {
        A annotation;
        Class<?> methodClass = method.getDeclaringClass();
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        Class<?> superclass = methodClass.getSuperclass();
        if (superclass != null && (annotation = ActorProxyFactory.getOverriddenAnnotationFrom(annotationClass, superclass, name, params)) != null) {
            return annotation;
        }
        for (Class<?> intf : methodClass.getInterfaces()) {
            A annotation2 = ActorProxyFactory.getOverriddenAnnotationFrom(annotationClass, intf, name, params);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    private static <A extends Annotation> A getOverriddenAnnotationFrom(Class<A> annotationClass, Class<?> searchClass, String name, Class<?>[] params) {
        try {
            Method method = searchClass.getMethod(name, params);
            A annotation = method.getAnnotation(annotationClass);
            if (annotation != null) {
                return annotation;
            }
            return ActorProxyFactory.getOverriddenAnnotation(annotationClass, method);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

