/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.util.concurrent.atomic.AtomicInteger;

public class RateMeasure {
    AtomicInteger count = new AtomicInteger(0);
    long lastStats;
    int checkEachMask = 7;
    long statInterval = 1000L;
    long lastRatePersecond;
    String name = "none";

    public RateMeasure(String name, long statInterval) {
        this.name = name;
        this.statInterval = statInterval;
    }

    public RateMeasure(String name) {
        this.name = name;
    }

    public long count() {
        int c = this.count.incrementAndGet();
        if ((c & ~this.checkEachMask) == c) {
            this.checkStats();
        }
        return this.lastRatePersecond;
    }

    public int getOpenCount() {
        return this.count.get();
    }

    private void checkStats() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastStats;
        if (diff > this.statInterval) {
            this.lastRatePersecond = (long)this.count.get() * 1000L / diff;
            this.lastStats = now;
            this.count.set(0);
            this.statsUpdated(this.lastRatePersecond);
        }
    }

    protected void statsUpdated(long lastRatePersecond) {
    }
}

