/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.base;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.remoting.base.ActorServerConnector;
import org.nustaq.kontraktor.remoting.base.ObjectSink;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.kontraktor.remoting.base.RemoteRefPolling;
import org.nustaq.kontraktor.remoting.base.RemoteRegistry;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.serialization.FSTConfiguration;

public class ActorServer {
    protected ActorServerConnector connector;
    protected Actor facade;
    AtomicInteger pollerCount = new AtomicInteger(0);
    protected ThreadLocal<RemoteRefPolling> poller = new ThreadLocal<RemoteRefPolling>(){

        @Override
        protected RemoteRefPolling initialValue() {
            if (ActorServer.this.pollerCount.get() > 0) {
                System.out.println("more than one poller started. used poller from wrong thread ?");
                Thread.dumpStack();
            }
            ActorServer.this.pollerCount.incrementAndGet();
            return new RemoteRefPolling();
        }
    };
    protected Coding coding;
    protected FSTConfiguration conf;

    public ActorServerConnector getConnector() {
        return this.connector;
    }

    public ActorServer(ActorServerConnector connector, Actor facade, Coding coding) throws Exception {
        this.facade = facade;
        if (facade.getActor().getClass().getAnnotation(Local.class) != null) {
            throw new RuntimeException("Local Actor cannot be remoted: " + facade.getActor().getClass().getName());
        }
        this.connector = connector;
        if (coding == null) {
            coding = new Coding(SerializerType.FSTSer);
        }
        this.coding = coding;
        this.conf = coding.createConf();
        this.conf.setName("MAINCONFIG");
        RemoteRegistry.registerDefaultClassMappings(this.conf);
        if (coding.getCrossPlatformShortClazzNames() != null) {
            this.conf.registerCrossPlatformClassMappingUseSimpleName(coding.getCrossPlatformShortClazzNames());
        }
    }

    public void start() throws Exception {
        this.start(null);
    }

    public void start(Consumer<Actor> disconnectHandler) throws Exception {
        this.connector.connect(this.facade, writesocket -> {
            final AtomicReference<ObjectSocket> socketRef = new AtomicReference<ObjectSocket>((ObjectSocket)writesocket);
            final RemoteRegistry reg = new RemoteRegistry(this.conf.deriveConfiguration(), this.coding){

                @Override
                public Actor getFacadeProxy() {
                    return ActorServer.this.facade;
                }

                @Override
                public AtomicReference<ObjectSocket> getWriteObjectSocket() {
                    return socketRef;
                }
            };
            reg.setDisconnectHandler(disconnectHandler);
            reg.constraints(this.connector.getConstraints());
            writesocket.setConf(reg.getConf());
            Actor.current();
            this.poller.get().scheduleSendLoop(reg);
            reg.setFacadeActor(this.facade);
            reg.publishActor(this.facade);
            reg.setServer(this);
            Log.Info((Object)this, "connected a client with registry " + System.identityHashCode(reg));
            return new ObjectSink(){

                @Override
                public void receiveObject(ObjectSink sink, Object received, List<IPromise> createdFutures, Object securityContext) {
                    try {
                        reg.receiveObject((ObjectSocket)socketRef.get(), sink, received, createdFutures, securityContext);
                    }
                    catch (Exception e) {
                        Log.Error((Object)this, e);
                    }
                }

                @Override
                public void sinkClosed() {
                    reg.disconnect();
                }
            };
        });
    }

    public IPromise close() {
        return this.connector.closeServer();
    }

    public Actor getFacade() {
        return this.facade;
    }
}

