/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.util.Log;

public class RateMeasure {
    AtomicInteger count = new AtomicInteger(0);
    long lastStats;
    int checkEachMask = 127;
    long statInterval = 1000L;
    long lastRatePersecond;
    String name = "none";

    public RateMeasure(String name, long statInterval) {
        this.name = name;
        this.statInterval = statInterval;
    }

    public RateMeasure(String name) {
        this.name = name;
    }

    public void count() {
        int c = this.count.incrementAndGet();
        if ((c & ~this.checkEachMask) == c) {
            this.checkStats();
        }
    }

    private void checkStats() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastStats;
        if (diff > this.statInterval) {
            this.lastRatePersecond = (long)this.count.get() * 1000L / diff;
            this.lastStats = now;
            this.count.set(0);
            this.statsUpdated(this.lastRatePersecond);
        }
    }

    protected void statsUpdated(long lastRatePersecond) {
        Log.Info((Object)this, "***** Stats for " + this.name + ":   " + lastRatePersecond + "   per second *********");
    }
}

