/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.impl.CallbackWrapper;
import org.nustaq.serialization.annotations.AnonymousTransient;

@AnonymousTransient
public abstract class Spore<I, O>
implements Serializable,
Cloneable {
    Callback cb;
    protected transient boolean finished;
    transient Callback<O> localCallback;
    transient Promise finSignal = new Promise();
    transient AtomicInteger finishLatch;

    public Spore() {
        Callback mycb = new Callback(){

            public void complete(Object result, Object error) {
                if (Actors.isComplete(error)) {
                    if (Spore.this.finishLatch != null) {
                        int count = Spore.this.finishLatch.decrementAndGet();
                        if (count == 0) {
                            Spore.this.finSignal.complete();
                        }
                    } else {
                        Spore.this.finSignal.complete();
                    }
                } else if (Spore.this.localCallback != null) {
                    Spore.this.localCallback.complete(result, error);
                } else {
                    System.err.println("set callback using then() prior sending");
                }
            }
        };
        this.cb = new CallbackWrapper(Actor.sender.get(), mycb);
    }

    public void setExpectedFinishCount(int count) {
        this.finishLatch = new AtomicInteger(count);
    }

    public abstract void remote(I var1);

    public Spore<I, O> forEach(Callback<O> cb) {
        if (this.localCallback != null) {
            throw new RuntimeException("forEachResult callback handler can only be set once.");
        }
        this.localCallback = cb;
        return this;
    }

    public Spore<I, O> onFinish(Runnable toRun) {
        this.finSignal.then(toRun);
        return this;
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.cb.complete(null, null);
        this.finished = true;
    }

    protected void streamError(Object err) {
        this.cb.complete(null, err);
    }

    protected void stream(O result) {
        this.cb.complete(result, "CNT");
    }

    public void complete(O res, Object err) {
        this.cb.complete(res, err);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Spore clone() {
        try {
            return (Spore)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

