/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.encoding;

import java.io.IOException;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.remoting.base.RemoteRegistry;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class ActorRefSerializer
extends FSTBasicObjectSerializer {
    RemoteRegistry reg;

    public ActorRefSerializer(RemoteRegistry reg) {
        this.reg = reg;
    }

    public void readObject(FSTObjectInput in, Object toRead, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy) throws Exception {
    }

    public boolean alwaysCopy() {
        return super.alwaysCopy();
    }

    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws Exception {
        int id = in.readInt();
        String clzName = in.readStringUTF();
        if (clzName.endsWith("_ActorProxy")) {
            clzName = clzName.substring(0, clzName.length() - "_ActorProxy".length());
        }
        Class<?> actorClz = Class.forName(clzName, true, this.reg.getConf().getClassLoader());
        Actor actorRef = this.reg.registerRemoteActorRef(actorClz, id, null);
        in.registerObject((Object)actorRef, streamPositioin, serializationInfo, referencee);
        return actorRef;
    }

    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Actor act = (Actor)toWrite;
        int id = this.reg.publishActor(act);
        out.writeInt(id);
        out.writeStringUTF(act.getActorRef().getClass().getName());
    }
}

