/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.tcp;

import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.remoting.base.ActorPublisher;
import org.nustaq.kontraktor.remoting.base.ActorServer;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.tcp.NIOServerConnector;

public class TCPNIOPublisher
implements ActorPublisher {
    Actor facade;
    int port = 6543;
    Coding coding = new Coding(SerializerType.FSTSer);

    public TCPNIOPublisher() {
    }

    public TCPNIOPublisher(Actor facade, int port) {
        this.facade = facade;
        this.port = port;
    }

    @Override
    public IPromise<ActorServer> publish() {
        return NIOServerConnector.Publish(this.facade, this.port, this.coding);
    }

    public TCPNIOPublisher serType(SerializerType type) {
        this.coding = new Coding(type);
        return this;
    }

    public TCPNIOPublisher facade(Actor facade) {
        this.facade = facade;
        return this;
    }

    public TCPNIOPublisher port(int port) {
        this.port = port;
        return this;
    }

    public TCPNIOPublisher coding(Coding coding) {
        this.coding = coding;
        return this;
    }

    public Actor getFacade() {
        return this.facade;
    }

    public int getPort() {
        return this.port;
    }

    public Coding getCoding() {
        return this.coding;
    }
}

