/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.asyncio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.asyncio.AsyncSocketConnection;
import org.nustaq.kontraktor.asyncio.QueuingAsyncSocketConnection;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.offheap.BinaryQueue;

public class _AsyncClientSocket
implements Runnable {
    SocketChannel channel;
    Selector selector;
    BiFunction<SelectionKey, SocketChannel, AsyncSocketConnection> connectionFactory;
    AsyncSocketConnection con;
    Promise connectFuture;

    public IPromise connect(String host, int port, BiFunction<SelectionKey, SocketChannel, AsyncSocketConnection> connectionFactory) {
        if (this.connectFuture != null) {
            throw new RuntimeException("illegal state, connect is underway");
        }
        this.connectFuture = new Promise();
        this.connectionFactory = connectionFactory;
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.selector = Selector.open();
            this.channel.register(this.selector, 13);
            this.channel.connect(new InetSocketAddress(host, port));
            Actor.current().execute(this);
        }
        catch (Exception e) {
            this.connectFuture.reject(e);
            this.connectFuture = null;
        }
        return this.connectFuture;
    }

    @Override
    public void run() {
        boolean hadStuff = false;
        try {
            this.selector.selectNow();
            Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = selectionKeys.iterator();
            while (iterator.hasNext()) {
                ByteBuffer writingBuffer;
                SelectionKey key = iterator.next();
                if (key.isConnectable() && this.connectFuture != null) {
                    boolean connected = this.channel.finishConnect();
                    this.con = this.connectionFactory.apply(key, this.channel);
                    iterator.remove();
                    this.connectFuture.resolve();
                    this.connectFuture = null;
                }
                if (this.con == null) continue;
                boolean wrote = false;
                if (key.isWritable() && (writingBuffer = this.con.getWritingBuffer()) != null) {
                    int written = this.channel.write(writingBuffer);
                    if (written < 0) {
                        wrote = true;
                        iterator.remove();
                        key.cancel();
                        this.con.writeFinished("disconnected");
                    } else if (writingBuffer.remaining() == 0) {
                        wrote = true;
                        iterator.remove();
                        this.con.writeFinished(null);
                    }
                }
                if (wrote || !key.isReadable()) continue;
                hadStuff = true;
                try {
                    if (this.con.readData()) continue;
                    iterator.remove();
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                    this.con.closed(ioe);
                    key.cancel();
                    try {
                        this.channel.close();
                    }
                    catch (IOException e) {
                        Log.Warn((Object)this, e);
                    }
                }
            }
        }
        catch (Throwable e) {
            Log.Warn(this, e, "");
            Actors.reject(e);
            try {
                this.close();
            }
            catch (IOException e1) {
                Log.Warn(this, e, "");
            }
        }
        if (!this.isClosed()) {
            if (hadStuff) {
                Actor.current().execute(this);
            } else {
                Actor.current().delayed(2L, this);
            }
        } else {
            System.out.println("loop terminated");
        }
    }

    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public AsyncSocketConnection getConnection() {
        return this.con;
    }

    public static void main(String[] a) throws InterruptedException {
        CLSActor act = Actors.AsActor(CLSActor.class);
        act.connect();
        Thread.sleep(10000000L);
    }

    public static class CLSActor
    extends Actor<CLSActor> {
        _AsyncClientSocket sock;

        public void connect() {
            this.sock = new _AsyncClientSocket();
            this.sock.connect("localhost", 8080, (key, channel) -> new QueuingAsyncSocketConnection((SelectionKey)key, (SocketChannel)channel){

                @Override
                protected void dataReceived(BinaryQueue queue) {
                    System.out.println("received:" + queue.remaining());
                }
            }).await();
            this.delayed(1000L, () -> this.loop());
        }

        public void loop() {
            QueuingAsyncSocketConnection con = (QueuingAsyncSocketConnection)this.sock.getConnection();
            con.write("Hello\n".getBytes());
            con.tryFlush();
            this.delayed(1000L, () -> this.loop());
        }
    }
}

