/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.asyncio;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;

public abstract class AsyncSocketConnection {
    protected ByteBuffer readBuf = ByteBuffer.allocateDirect(4096);
    protected SelectionKey key;
    protected SocketChannel chan;
    protected Promise writePromise;
    protected ByteBuffer writingBuffer;
    boolean isClosed;
    Thread debug;

    public AsyncSocketConnection(SelectionKey key, SocketChannel chan) {
        this.key = key;
        this.chan = chan;
    }

    public void closed(Exception ioe) {
        System.out.println("connection closed " + ioe);
        this.isClosed = true;
    }

    public void close() throws IOException {
        this.chan.close();
    }

    boolean readData() throws IOException {
        this.checkThread();
        this.readBuf.position(0);
        this.readBuf.limit(this.readBuf.capacity());
        int read = this.chan.read(this.readBuf);
        if (read == -1) {
            throw new EOFException("connection closed");
        }
        this.readBuf.flip();
        if (this.readBuf.limit() > 0) {
            this.dataReceived(this.readBuf);
        }
        return read == this.readBuf.capacity();
    }

    protected void checkThread() {
        if (this.debug == null) {
            this.debug = Thread.currentThread();
        } else if (this.debug != Thread.currentThread()) {
            throw new RuntimeException("unexpected multithreading");
        }
    }

    protected IPromise directWrite(ByteBuffer buf) {
        this.checkThread();
        if (this.writePromise != null) {
            throw new RuntimeException("concurrent write con:" + this.chan.isConnected() + " open:" + this.chan.isOpen());
        }
        this.writePromise = new Promise();
        this.writingBuffer = buf;
        Promise res = this.writePromise;
        try {
            int written = 0;
            written = this.chan.write(buf);
            if (written < 0) {
                this.writeFinished("disconnected");
            }
            if (buf.remaining() <= 0) {
                this.writeFinished(null);
            }
        }
        catch (Exception e) {
            res.reject(e);
        }
        return res;
    }

    ByteBuffer getWritingBuffer() {
        return this.writingBuffer;
    }

    public boolean canWrite() {
        return this.writePromise == null;
    }

    void writeFinished(Object error) {
        this.checkThread();
        this.writingBuffer = null;
        Promise wp = this.writePromise;
        this.writePromise = null;
        if (!wp.isSettled()) {
            if (error != null) {
                wp.reject(error);
            } else {
                wp.complete();
            }
        }
    }

    public abstract void dataReceived(ByteBuffer var1);

    public boolean isClosed() {
        return !this.chan.isOpen() && !this.isClosed;
    }
}

