/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.asyncio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.asyncio.AsyncSocketConnection;
import org.nustaq.kontraktor.util.Log;

public class AsyncServerSocket {
    ServerSocketChannel socket;
    Selector selector;
    SelectionKey serverkey;
    BiFunction<SelectionKey, SocketChannel, AsyncSocketConnection> connectionFactory;
    Thread t = null;

    public void connect(int port, BiFunction<SelectionKey, SocketChannel, AsyncSocketConnection> connectionFactory) throws IOException {
        this.selector = Selector.open();
        this.socket = ServerSocketChannel.open();
        this.socket.configureBlocking(false);
        this.socket.socket().bind(new InetSocketAddress(port));
        this.serverkey = this.socket.register(this.selector, 16);
        this.connectionFactory = connectionFactory;
        this.receiveLoop();
    }

    public void receiveLoop() {
        Actor actor = Actor.current();
        if (this.t == null) {
            this.t = Thread.currentThread();
        } else if (this.t != Thread.currentThread()) {
            System.out.println("FATAL");
            System.exit(-1);
        }
        boolean hadStuff = false;
        int iterCount = 10;
        do {
            try {
                this.selector.selectNow();
                Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> iterator = selectionKeys.iterator();
                while (iterator.hasNext()) {
                    SelectionKey key = iterator.next();
                    try {
                        ByteBuffer writingBuffer;
                        AsyncSocketConnection con;
                        if (key == this.serverkey) {
                            SocketChannel accept;
                            if (!key.isAcceptable() || (accept = this.socket.accept()) == null) continue;
                            hadStuff = true;
                            accept.configureBlocking(false);
                            SelectionKey newKey = accept.register(this.selector, 5);
                            con = this.connectionFactory.apply(key, accept);
                            newKey.attach(con);
                            continue;
                        }
                        SocketChannel client = (SocketChannel)key.channel();
                        int written = 0;
                        if (key.isWritable() && (writingBuffer = (con = (AsyncSocketConnection)key.attachment()).getWritingBuffer()) != null) {
                            hadStuff = true;
                            try {
                                written = con.chan.write(writingBuffer);
                                if (written < 0) {
                                    iterator.remove();
                                    key.cancel();
                                    con.writeFinished("disconnected");
                                } else if (writingBuffer.remaining() == 0) {
                                    iterator.remove();
                                    con.writeFinished(null);
                                }
                            }
                            catch (IOException ioe) {
                                iterator.remove();
                                key.cancel();
                                con.writeFinished("disconnected");
                            }
                        }
                        if (!key.isReadable() || written != 0) continue;
                        iterator.remove();
                        con = (AsyncSocketConnection)key.attachment();
                        if (con == null || con.isClosed()) {
                            Log.Lg.warn(this, "con is null " + key);
                            continue;
                        }
                        hadStuff = true;
                        try {
                            if (con.readData()) continue;
                        }
                        catch (Exception ioe) {
                            con.closed(ioe);
                            key.cancel();
                            try {
                                client.close();
                            }
                            catch (IOException e) {
                                Log.Warn((Object)this, e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        Log.Warn(this, e, "");
                    }
                }
            }
            catch (Throwable e) {
                Log.Warn(this, e, "");
                Actors.reject(e);
            }
        } while (iterCount-- > 0 && hadStuff);
        if (!this.isClosed()) {
            if (hadStuff) {
                actor.execute(() -> this.receiveLoop());
            } else {
                actor.delayed(1L, () -> this.receiveLoop());
            }
        }
    }

    public boolean isClosed() {
        return !this.socket.isOpen();
    }

    public void close() throws IOException {
        this.socket.close();
    }
}

