/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.ActorProxy;
import org.nustaq.kontraktor.remoting.RemoteRefRegistry;
import org.nustaq.kontraktor.remoting.tcp.TCPSocket;
import org.nustaq.kontraktor.util.Log;

public class TCPActorServer {
    protected List<ActorServerClientConnection> connections = new ArrayList<ActorServerClientConnection>();
    Actor facadeActor;
    int port;
    ServerSocket welcomeSocket;
    protected volatile boolean terminated = false;

    public static TCPActorServer Publish(Actor act, int port) throws IOException {
        TCPActorServer server = new TCPActorServer((ActorProxy)((Object)act), port);
        new Thread(() -> {
            try {
                server.start();
            }
            catch (IOException e) {
                Log.Warn(TCPActorServer.class, e, "");
            }
        }, "acceptor " + port).start();
        return server;
    }

    public TCPActorServer(ActorProxy proxy, int port) throws IOException {
        this.port = port;
        this.facadeActor = (Actor)((Object)proxy);
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
        this.connections.forEach(con -> con.setTerminated(true));
    }

    public void start() throws IOException {
        try {
            this.welcomeSocket = new ServerSocket(this.port);
            Log.Info(this, this.facadeActor.getActor().getClass().getName() + " running on " + this.welcomeSocket.getLocalPort());
            while (!this.terminated) {
                Socket connectionSocket = this.welcomeSocket.accept();
                ActorServerClientConnection clientConnection = new ActorServerClientConnection(connectionSocket, this.facadeActor);
                this.connections.add(clientConnection);
                clientConnection.start();
            }
        }
        finally {
            this.setTerminated(true);
        }
    }

    public class ActorServerClientConnection
    extends RemoteRefRegistry {
        TCPSocket channel;
        Actor facade;

        public ActorServerClientConnection(Socket s, Actor facade) throws IOException {
            this.channel = new TCPSocket(s, this.conf);
            this.facade = facade;
        }

        public void start() {
            this.publishActor(this.facade);
            new Thread(() -> {
                try {
                    this.currentObjectSocket.set(this.channel);
                    this.receiveLoop(this.channel);
                }
                catch (Exception ex) {
                    Log.Warn(this, ex, "");
                }
                this.setTerminated(true);
                TCPActorServer.this.connections.remove(this);
            }, "receiver").start();
            new Thread(() -> {
                try {
                    this.currentObjectSocket.set(this.channel);
                    this.sendLoop(this.channel);
                }
                catch (Exception ex) {
                    Log.Warn(this, ex, "");
                }
                this.setTerminated(true);
                TCPActorServer.this.connections.remove(this);
            }, "sender").start();
        }

        @Override
        public void close() {
            super.close();
            try {
                this.channel.close();
            }
            catch (IOException e) {
                Log.Warn(this, e, "");
            }
        }

        @Override
        public Actor getFacadeProxy() {
            return this.facade;
        }
    }
}

