/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.tcp;

import java.io.IOException;
import java.net.SocketException;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Future;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.RemoteConnection;
import org.nustaq.kontraktor.impl.BackOffStrategy;
import org.nustaq.kontraktor.impl.RemoteScheduler;
import org.nustaq.kontraktor.remoting.ObjectSocket;
import org.nustaq.kontraktor.remoting.RemoteRefRegistry;
import org.nustaq.kontraktor.remoting.tcp.TCPSocket;
import org.nustaq.kontraktor.util.Log;

public class TCPActorClient<T extends Actor>
extends RemoteRefRegistry {
    Class<? extends Actor> actorClazz;
    T facadeProxy;
    BackOffStrategy backOffStrategy = new BackOffStrategy();
    String host;
    int port;
    ActorClient client;
    int maxTrialConnect = 60;
    volatile boolean connected = false;

    public static <AC extends Actor> Future<AC> Connect(Class<AC> clz, String host, int port) throws IOException {
        Promise res = new Promise();
        TCPActorClient client = new TCPActorClient(clz, host, port);
        new Thread(() -> {
            try {
                client.connect();
                res.receive(client.getFacadeProxy(), (Object)null);
            }
            catch (IOException e) {
                Log.Warn(TCPActorClient.class, e, "");
                res.receive((Object)null, (Object)e);
            }
        }, "connect " + super.getDescriptionString()).start();
        return res;
    }

    public TCPActorClient(Class<? extends Actor> clz, String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.actorClazz = clz;
        this.facadeProxy = Actors.AsActor(this.actorClazz, new RemoteScheduler());
        ((Actor)this.facadeProxy).__remoteId = 1;
        this.registerRemoteRefDirect((Actor)this.facadeProxy);
    }

    public T getFacadeProxy() {
        return this.facadeProxy;
    }

    public int getMaxTrialConnect() {
        return this.maxTrialConnect;
    }

    public void setMaxTrialConnect(int maxTrialConnect) {
        this.maxTrialConnect = maxTrialConnect;
    }

    public void connect() throws IOException {
        int count = 0;
        while (count < this.maxTrialConnect && !this.connected) {
            try {
                this.client = new ActorClient();
                this.connected = true;
                ((Actor)this.facadeProxy).__addRemoteConnection(this.client);
            }
            catch (Exception ex) {
                Log.Info(this, "connection to " + this.getDescriptionString() + " failed, retry " + ++count + " of " + this.maxTrialConnect);
                if (count < this.maxTrialConnect) continue;
                Log.Lg.error(this, ex, "connection failed. giving up");
                throw ex;
            }
        }
    }

    private String getDescriptionString() {
        return this.actorClazz.getSimpleName() + "@" + this.host + ":" + this.port;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    protected void remoteRefStopped(Actor actor) {
        super.remoteRefStopped(actor);
        if (actor.getActorRef() == ((Actor)this.facadeProxy).getActorRef()) {
            this.setTerminated(true);
            this.stopRemoteRefs();
            this.client.close();
        }
    }

    public class ActorClient
    implements RemoteConnection {
        ObjectSocket chan;

        public ActorClient() throws IOException {
            this.chan = new TCPSocket(TCPActorClient.this.host, TCPActorClient.this.port, TCPActorClient.this.conf);
            new Thread(() -> {
                TCPActorClient.this.currentObjectSocket.set(this.chan);
                try {
                    TCPActorClient.this.sendLoop(this.chan);
                }
                catch (IOException e) {
                    if (e instanceof SocketException) {
                        Log.Lg.infoLong(this, e, "");
                    }
                    Log.Warn(this, e, "");
                }
            }, "sender").start();
            new Thread(() -> {
                TCPActorClient.this.currentObjectSocket.set(this.chan);
                TCPActorClient.this.receiveLoop(this.chan);
            }, "receiver").start();
        }

        @Override
        public void close() {
            try {
                this.chan.close();
            }
            catch (IOException e) {
                Log.Warn(this, e, "");
            }
        }
    }
}

