/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.rest;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.Future;
import org.nustaq.kontraktor.remoting.RemoteCallEntry;
import org.nustaq.kontraktor.remoting.http.KontraktorHttpRequest;
import org.nustaq.kontraktor.remoting.http.NioHttpServer;
import org.nustaq.kontraktor.remoting.http.RequestProcessor;
import org.nustaq.kontraktor.remoting.http.RequestResponse;
import org.nustaq.kontraktor.remoting.http.rest.HttpMsgCoder;
import org.nustaq.kontraktor.remoting.http.rest.HttpRemotedCB;
import org.nustaq.kontraktor.remoting.http.rest.encoding.JSonMsgCoder;
import org.nustaq.kontraktor.remoting.http.rest.encoding.KsonMsgCoder;
import org.nustaq.kontraktor.remoting.http.rest.encoding.PlainJSonCoder;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.util.RateMeasure;
import org.nustaq.serialization.util.FSTUtil;

public class RestActorServer {
    NioHttpServer server;
    ConcurrentHashMap<String, PublishedActor> publishedActors = new ConcurrentHashMap();
    RateMeasure respPerS = new RateMeasure("responaes/s", 1000L);
    ConcurrentHashMap<String, Class> classNameMappings = new ConcurrentHashMap();

    protected void enqueueCall(PublishedActor target, KontraktorHttpRequest req, Callback<RequestResponse> response) {
        Method m = target.getActor().__getCachedMethod(req.getPath(1), target.getActor());
        if (m == null) {
            throw new RuntimeException("no such method '" + req.getPath(1) + "' on " + target.getActor().getClass().getSimpleName());
        }
        int args = m.getParameterCount();
        Class<?>[] parameterTypes = m.getParameterTypes();
        String json = "[ { method: " + req.getPath(1) + " args: [ ";
        for (int i = 0; i < args; ++i) {
            String path = req.getPath(i + 2);
            if (!(parameterTypes[i].isPrimitive() && Number.class.isAssignableFrom(parameterTypes[i]) || path.startsWith("'") || !path.startsWith("{"))) {
                path = "'" + path + "'";
            }
            if (path.equals("")) {
                Class<?> par;
                path = parameterTypes[i].isPrimitive() ? ((par = parameterTypes[i]) == Byte.TYPE || par == Short.TYPE || par == Character.TYPE || par == Integer.TYPE || par == Long.TYPE ? "0" : (par == Float.TYPE || par == Double.TYPE ? "0.0" : (par == Boolean.TYPE ? "false" : "null"))) : "null";
            }
            json = json + path + " ";
        }
        json = json + "] } ]";
        this.enqueueCall(target, json, req, response);
    }

    protected void enqueueCall(PublishedActor target, String content, KontraktorHttpRequest req, Callback<RequestResponse> response) {
        try {
            HttpMsgCoder coder = target.getCoder(req.getAccept()) == null ? target.getCoder("text/json") : target.getCoder(req.getAccept());
            RemoteCallEntry[] calls = coder.decodeFrom(content, req);
            response.receive(RequestResponse.MSG_200, null);
            AtomicInteger countDown = new AtomicInteger(calls.length);
            for (int i = 0; i < calls.length; ++i) {
                RemoteCallEntry call = calls[i];
                int cbid = call.getFutureKey();
                Object[] args = call.getArgs();
                for (int ii = 0; ii < args.length; ++ii) {
                    Object o = args[ii];
                    if (o instanceof Actor) {
                        throw new RuntimeException("remote actor references are not supported via http, use TCP stack");
                    }
                    if (!(o instanceof HttpRemotedCB)) continue;
                    cbid = ((HttpRemotedCB)o).getCbid();
                }
                int finalCB = cbid;
                Method m = target.getActor().__getCachedMethod(call.getMethod(), target.getActor());
                Callback<Object> cb = (r, e) -> {
                    boolean isContinue = "CNT" == e;
                    this.respPerS.count();
                    if (!isContinue) {
                        countDown.decrementAndGet();
                    }
                    String fin = countDown.get() <= 0 ? "FIN" : null;
                    RemoteCallEntry resCall = new RemoteCallEntry(0, finalCB, "receive", new Object[]{r, "" + e});
                    resCall.setQueue(1);
                    try {
                        String encode = coder.encode(resCall);
                        response.receive(new RequestResponse(encode), isContinue ? null : fin);
                    }
                    catch (Exception ex) {
                        Log.Warn(this, ex, "");
                        response.receive(new RequestResponse(FSTUtil.toString((Throwable)ex)), fin);
                    }
                };
                Class<?>[] parameterTypes = m.getParameterTypes();
                int cbCount = 0;
                for (int ii = 0; ii < parameterTypes.length; ++ii) {
                    Class<?> parameterType = parameterTypes[ii];
                    if (Actor.class.isAssignableFrom(parameterType)) {
                        response.receive(new RequestResponse("method not http enabled, actor remote references cannot be supported for Http based REST (use TCP stack)"), "FIN");
                        return;
                    }
                    if (!Callback.class.isAssignableFrom(parameterType)) continue;
                    if (cbCount > 0 || Future.class.isAssignableFrom(m.getReturnType())) {
                        response.receive(new RequestResponse("method not http enabled, more than one callback object in args, or callback and also returns future"), "FIN");
                        return;
                    }
                    ++cbCount;
                    call.getArgs()[ii] = cb;
                }
                Object future = target.getActor().__scheduler.enqueueCall(this.server.getServingActor(), target.getActor(), call.getMethod(), call.getArgs());
                if (future instanceof Future) {
                    ((Future)future).then(cb);
                    continue;
                }
                if (m.getReturnType() != Void.TYPE || cbCount != 0) continue;
                this.respPerS.count();
                if (countDown.decrementAndGet() != 0) continue;
                response.receive(null, "FIN");
            }
        }
        catch (Exception e2) {
            Log.Warn(this, e2, "");
            response.receive(RequestResponse.MSG_500, "" + e2);
        }
    }

    public void startOnServer(int port, NioHttpServer server) {
        this.server = server;
        server.$init(port, new RestProcessor());
        server.$receive();
    }

    public PublishedActor publish(String name, Actor obj) {
        PublishedActor pa = new PublishedActor(obj, this.classNameMappings);
        this.publishedActors.put(name, pa);
        return pa;
    }

    public void unpublish(String name) {
        this.publishedActors.remove(name);
    }

    public RestActorServer map(String s, Class clz) {
        this.classNameMappings.put(s, clz);
        return this;
    }

    public RestActorServer map(Class ... clz) {
        for (int i = 0; i < clz.length; ++i) {
            Class aClass = clz[i];
            this.map(clz[i].getSimpleName(), clz[i]);
        }
        return this;
    }

    public static class PublishedActor {
        Actor actor;
        HashMap<String, HttpMsgCoder> coders = new HashMap();

        public PublishedActor(Actor actor, Map<String, Class> mappings) {
            this.actor = actor;
            KsonMsgCoder kson = new KsonMsgCoder(actor.getActor().getClass());
            JSonMsgCoder json = new JSonMsgCoder(actor.getActor().getClass());
            PlainJSonCoder plainJson = new PlainJSonCoder(actor.getActor().getClass());
            mappings.forEach((name, clz) -> {
                kson.map((String)name, (Class)clz);
                json.map((String)name, (Class)clz);
                plainJson.map((String)name, (Class)clz);
            });
            this.coders.put("text/kson", kson);
            this.coders.put("text/json", plainJson);
            this.coders.put("text/json-tagged", json);
        }

        public PublishedActor putCoder(String name, HttpMsgCoder coder) {
            this.coders.put(name, coder);
            return this;
        }

        public HttpMsgCoder getCoder(String name) {
            return this.coders.get(name);
        }

        public Actor getActor() {
            return this.actor;
        }
    }

    public class RestProcessor
    implements RequestProcessor {
        @Override
        public void processRequest(KontraktorHttpRequest req, Callback<RequestResponse> response) {
            if (req.isGET()) {
                String actor = req.getPath(0);
                PublishedActor target = RestActorServer.this.publishedActors.get(actor);
                if (target == null) {
                    response.receive(RequestResponse.MSG_404, null);
                    response.receive(null, "FIN");
                } else {
                    RestActorServer.this.enqueueCall(target, req, response);
                }
            } else if (req.isPOST()) {
                String actor = req.getPath(0);
                PublishedActor target = RestActorServer.this.publishedActors.get(actor);
                if (target == null) {
                    response.receive(RequestResponse.MSG_404, null);
                    response.receive(null, "FIN");
                } else {
                    RestActorServer.this.enqueueCall(target, req.getText().toString(), req, response);
                }
            } else {
                response.receive(RequestResponse.MSG_404, null);
                response.receive(null, "FIN");
            }
        }
    }
}

