/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.rest;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.impl.RemoteScheduler;
import org.nustaq.kontraktor.remoting.ObjectSocket;
import org.nustaq.kontraktor.remoting.RemoteCallEntry;
import org.nustaq.kontraktor.remoting.RemoteRefRegistry;
import org.nustaq.kontraktor.remoting.http.rest.HttpObjectSocket;
import org.nustaq.kontraktor.remoting.http.rest.HttpRemotedCB;
import org.nustaq.kontraktor.util.Log;

public class RestActorClient<T extends Actor>
extends RemoteRefRegistry {
    T facadeProxy;
    int port = 9999;
    String host;
    String actorPath;
    Class<T> actorClazz;
    HttpObjectSocket channel;
    ConcurrentHashMap<String, Class> mappings = new ConcurrentHashMap();

    public RestActorClient(String host, int port, String actorPath, Class clz) {
        this.port = port;
        this.host = host;
        this.actorPath = actorPath;
        this.actorClazz = clz;
        this.facadeProxy = Actors.AsActor(this.actorClazz, new RemoteScheduler());
        ((Actor)this.facadeProxy).__remoteId = 0;
        this.registerRemoteRefDirect((Actor)this.facadeProxy);
    }

    public T getFacadeProxy() {
        return this.facadeProxy;
    }

    public RestActorClient<T> connect() {
        this.channel = new HttpObjectSocket(this.actorClazz, this.port, this.host, this.actorPath);
        this.mappings.forEach((k, v) -> this.channel.getKson().map(k, v));
        new Thread(() -> {
            try {
                this.sendLoop(this.channel);
            }
            catch (IOException e) {
                Log.Warn(this, e, "");
            }
        }, "sender").start();
        new Thread(() -> this.receiveLoop(this.channel), "receiver").start();
        return this;
    }

    @Override
    protected void writeObject(ObjectSocket chan, RemoteCallEntry rce) throws Exception {
        Object[] args = rce.getArgs();
        for (int i = 0; i < args.length; ++i) {
            Object o = args[i];
            if (o instanceof Callback) {
                int cbid = this.registerPublishedCallback((Callback)o);
                args[i] = new HttpRemotedCB(cbid);
            }
            if (!(o instanceof Actor)) continue;
            throw new RuntimeException("remote actor references are not supported via http");
        }
        super.writeObject(chan, rce);
    }

    public RestActorClient<T> map(String s, Class clz) {
        this.mappings.put(s, clz);
        if (this.channel != null) {
            this.channel.getKson().map(s, clz);
        }
        return this;
    }

    public RestActorClient<T> map(Class ... clz) {
        for (int i = 0; i < clz.length; ++i) {
            Class aClass = clz[i];
            this.map(clz[i].getSimpleName(), clz[i]);
        }
        return this;
    }
}

