/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import org.nustaq.kontraktor.remoting.http.KontraktorHttpRequest;
import org.nustaq.kontraktor.util.Log;

public class KontraktorHttpRequestImpl
implements KontraktorHttpRequest {
    byte[] bytes;
    StringBuilder text = new StringBuilder(1000);
    StringBuilder methodString = new StringBuilder();
    StringBuilder pathString = new StringBuilder();
    String[] splitPath;
    int contentStart;
    int contentLength;
    String accept = "text/json";
    boolean isComplete = false;

    public KontraktorHttpRequestImpl(ByteBuffer buffer, int len) {
        this.bytes = new byte[len];
        buffer.get(this.bytes);
        this.checkComplete();
    }

    @Override
    public void append(ByteBuffer buf, int len) {
        Log.Info(this, "PARTIAL READ");
        if (!this.hadHeader()) {
            Log.Info(this, "..complete header");
            byte[] newbytes = new byte[this.bytes.length + len];
            System.arraycopy(this.bytes, 0, newbytes, 0, this.bytes.length);
            buf.get(newbytes, this.bytes.length, len);
            this.bytes = newbytes;
            this.checkComplete();
            Log.Info(this, "..complete:" + this.isComplete());
        } else {
            Log.Info(this, "..complete body");
            byte[] tmp = new byte[len];
            buf.get(tmp);
            try {
                this.text.append(new String(tmp, "UTF-8"));
                this.isComplete = this.text.length() >= this.contentLength;
                Log.Info(this, "..complete:" + this.isComplete() + " text:" + this.text.length() + " cont:" + this.contentLength);
            }
            catch (UnsupportedEncodingException e) {
                Log.Warn(this, e, "");
                this.isComplete = true;
            }
        }
    }

    protected boolean hadHeader() {
        return this.contentStart != 0;
    }

    private void checkComplete() {
        for (int i = 4; i < this.bytes.length; ++i) {
            if ((this.bytes[i] != 10 || this.bytes[i - 1] != 10) && (this.bytes[i] != 10 || this.bytes[i - 1] != 13 || this.bytes[i - 2] != 10 || this.bytes[i - 3] != 13)) continue;
            this.contentStart = i + 1;
            this.parseHeader();
            try {
                this.text.append(new String(this.bytes, this.contentStart, this.bytes.length - this.contentStart, "UTF-8"));
                this.isComplete = this.text.length() >= this.contentLength;
                this.bytes = null;
            }
            catch (UnsupportedEncodingException e) {
                Log.Warn(this, e, "");
                this.isComplete = true;
            }
            return;
        }
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    private void parseHeader() {
        int idx = 0;
        byte b = 0;
        StringBuffer keyString = new StringBuffer();
        StringBuffer valString = new StringBuffer();
        boolean key = true;
        boolean method = true;
        boolean path = false;
        boolean protocol = false;
        while (true) {
            if ((b = this.bytes[idx++]) == 0 || b == 13) {
                continue;
            }
            if (key) {
                if (b == 10) {
                    if (!method) break;
                    keyString.setLength(0);
                    method = false;
                    path = false;
                    continue;
                }
                if (b != 58 || path) {
                    if (method) {
                        if (Character.isWhitespace(b) && !path) {
                            path = true;
                            continue;
                        }
                        if (path) {
                            if (Character.isWhitespace(b)) {
                                protocol = true;
                                continue;
                            }
                            if (protocol) continue;
                            this.pathString.append((char)b);
                            continue;
                        }
                        this.methodString.append((char)Character.toUpperCase(b));
                        continue;
                    }
                    keyString.append((char)Character.toUpperCase(b));
                    continue;
                }
                key = false;
                continue;
            }
            if (b != 10) {
                valString.append((char)b);
                continue;
            }
            if (keyString.toString().equalsIgnoreCase("CONTENT-LENGTH")) {
                this.contentLength = Integer.parseInt(valString.toString().trim());
            } else if (keyString.toString().equalsIgnoreCase("ACCEPT")) {
                this.accept = valString.toString().toLowerCase().trim();
            }
            keyString.setLength(0);
            valString.setLength(0);
            key = true;
        }
    }

    @Override
    public String getAccept() {
        return this.accept;
    }

    @Override
    public StringBuilder getText() {
        return this.text;
    }

    @Override
    public boolean isGET() {
        return this.methodString.charAt(0) == 'G';
    }

    @Override
    public String getPath(int i) {
        if (this.splitPath == null) {
            this.splitPath = this.pathString.toString().split("/");
        }
        if (i + 1 < this.splitPath.length) {
            try {
                return URLDecoder.decode(this.splitPath[i + 1], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "url decoding failed";
            }
        }
        return "";
    }

    @Override
    public boolean isPOST() {
        return this.methodString.charAt(0) == 'P';
    }

    public int getPathLen() {
        return this.splitPath.length - 1;
    }
}

