/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.Filter;
import org.nustaq.kontraktor.Future;

public class Promise<T>
implements Future<T> {
    protected Object result;
    protected Object error;
    protected Callback resultReceiver;
    protected boolean hadResult;
    protected boolean hasFired;
    final AtomicBoolean lock = new AtomicBoolean(false);
    String id;
    Future nextFuture;

    public Promise(T result, Object error) {
        this.result = result;
        this.error = error;
        this.hadResult = true;
    }

    public Promise(T result) {
        this(result, null);
    }

    public Promise() {
    }

    public String getId() {
        return this.id;
    }

    public Promise<T> setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public <OUT> Future<OUT> map(final Filter<T, OUT> filter) {
        final Promise<T> promise = new Promise<T>();
        this.then(new Callback<T>(){

            @Override
            public void receive(T result, Object error) {
                filter.map(result, error).then(promise);
            }
        });
        return promise;
    }

    @Override
    public Future then(Callback resultCB) {
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.resultReceiver != null) {
                throw new RuntimeException("Double register of future listener");
            }
            this.resultReceiver = resultCB;
            if (this.hadResult) {
                this.hasFired = true;
                if (this.nextFuture == null) {
                    this.nextFuture = new Promise<Object>(this.result, this.error);
                    this.lock.set(false);
                    resultCB.receive(this.result, this.error);
                } else {
                    this.lock.set(false);
                    resultCB.receive(this.result, this.error);
                    this.nextFuture.receive(this.result, this.error);
                    Future future = this.nextFuture;
                    return future;
                }
            }
            if (resultCB instanceof Future) {
                Future future = (Future)resultCB;
                return future;
            }
            this.lock.set(false);
            while (!this.lock.compareAndSet(false, true)) {
            }
            if (this.nextFuture == null) {
                Promise<T> promise = this.nextFuture = new Promise<T>();
                return promise;
            }
            Future future = this.nextFuture;
            return future;
        }
        finally {
            this.lock.set(false);
        }
    }

    public Promise getNext() {
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.nextFuture == null) {
                Promise<T> promise = new Promise<T>();
                return promise;
            }
            Promise promise = (Promise)this.nextFuture;
            return promise;
        }
        finally {
            this.lock.set(false);
        }
    }

    public Promise getLast() {
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.nextFuture == null) {
                Promise promise = this;
                return promise;
            }
            Promise promise = ((Promise)this.nextFuture).getLast();
            return promise;
        }
        finally {
            this.lock.set(false);
        }
    }

    public void finishWith(Callback resultCB) {
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.resultReceiver != null) {
                throw new RuntimeException("Double register of future listener");
            }
            this.resultReceiver = resultCB;
            if (this.hadResult) {
                this.hasFired = true;
                this.lock.set(false);
                resultCB.receive(this.result, this.error);
            }
        }
        finally {
            this.lock.set(false);
        }
    }

    @Override
    public final void receive(Object res, Object error) {
        this.result = res;
        this.error = error;
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.hadResult) {
                this.lock.set(false);
                throw new RuntimeException("Double result received on future");
            }
            this.hadResult = true;
            if (this.resultReceiver != null) {
                if (this.hasFired) {
                    this.lock.set(false);
                    throw new RuntimeException("Double fire on callback");
                }
                this.hasFired = true;
                this.lock.set(false);
                this.resultReceiver.receive(this.result, error);
                this.resultReceiver = null;
                while (!this.lock.compareAndSet(false, true)) {
                }
                if (this.nextFuture != null) {
                    this.lock.set(false);
                    this.nextFuture.receive(this.result, error);
                }
                return;
            }
        }
        finally {
            this.lock.set(false);
        }
    }

    @Override
    public T getResult() {
        return (T)this.result;
    }

    @Override
    public void signal() {
        this.receive((Object)null, (Object)null);
    }

    @Override
    public Object getError() {
        return this.error;
    }

    public boolean _isHadResult() {
        return this.hadResult;
    }

    public boolean _isHasFired() {
        return this.hasFired;
    }

    public String toString() {
        return "Result{result=" + this.result + ", error=" + this.error + '}';
    }
}

