/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.Future;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.RemoteConnection;
import org.nustaq.kontraktor.Scheduler;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.impl.ActorProxyFactory;
import org.nustaq.kontraktor.impl.ActorStoppedException;

public class Actor<SELF extends Actor>
implements Serializable {
    public static final String FINSILENT = "EOT";
    public static final String CONT = "CNT";
    public static final String FIN = "FIN";
    public static ThreadLocal<Actor> sender = new ThreadLocal();
    public Queue __mailbox;
    public int __mbCapacity;
    public Queue __cbQueue;
    public Thread __currentDispatcher;
    public Scheduler __scheduler;
    public volatile boolean __stopped = false;
    public long __nanos;
    public Actor __self;
    public int __remoteId;
    public volatile ConcurrentLinkedQueue<RemoteConnection> __connections;
    ConcurrentLinkedQueue<Callback<SELF>> __stopHandlers;
    Thread _t;
    ConcurrentHashMap<String, Method> methodCache = new ConcurrentHashMap();

    public static boolean Fin(Object o) {
        return FIN.equals(o) || FINSILENT.equals(o) || o == null;
    }

    public static boolean Cont(Object o) {
        return CONT.equals(o);
    }

    protected SELF self() {
        return (SELF)this.__self;
    }

    public ActorProxyFactory getFactory() {
        return Actors.instance.getFactory();
    }

    public SELF getActor() {
        return (SELF)this;
    }

    public void $stop() {
        this.__stop();
    }

    @CallerSideMethod
    public boolean isStopped() {
        return this.__stopped;
    }

    @CallerSideMethod
    public boolean isProxy() {
        return this.getActor() != this;
    }

    protected Future<Future[]> yield(Future ... futures) {
        return this.__scheduler.yield(futures);
    }

    protected <T> Future<List<Future<T>>> yieldList(List<Future<T>> futures) {
        return this.__scheduler.yield(futures);
    }

    protected <T> Future<T> async(Callable<T> callable) {
        Promise prom = new Promise();
        this.__scheduler.runBlockingCall((Actor)this.self(), callable, prom);
        return prom;
    }

    @CallerSideMethod
    protected <T> T inThread(Actor proxy, T cbInterface) {
        return this.__scheduler.inThread(proxy, cbInterface);
    }

    protected void delayed(long millis, Runnable toRun) {
        this.__scheduler.delayedCall(millis, this.inThread((Actor)this.self(), (Object)toRun));
    }

    @CallerSideMethod
    public Scheduler getScheduler() {
        return this.__scheduler;
    }

    @CallerSideMethod
    public boolean isMailboxPressured() {
        return this.__mailbox.size() * 2 > this.__mbCapacity;
    }

    @CallerSideMethod
    public boolean isCallbackQPressured() {
        return this.__cbQueue.size() * 2 > this.__mbCapacity;
    }

    @CallerSideMethod
    public int getMailboxSize() {
        return this.__mailbox.size();
    }

    @CallerSideMethod
    public int getCallbackSize() {
        return this.__cbQueue.size();
    }

    protected final void checkThread() {
        if (this._t == null) {
            this._t = Thread.currentThread();
        } else if (this._t != Thread.currentThread()) {
            throw new RuntimeException("Wrong Thread");
        }
    }

    @CallerSideMethod
    public Actor getActorRef() {
        return this.__self;
    }

    @CallerSideMethod
    public boolean isRemote() {
        return this.__remoteId != 0;
    }

    public void $close() {
        if (this.__connections != null) {
            ConcurrentLinkedQueue<RemoteConnection> prevCon = this.__connections;
            this.__connections = null;
            prevCon.forEach(con -> con.close());
        }
    }

    @CallerSideMethod
    public void stopSafeClose() {
        if (this.isStopped()) {
            ((Actor)this.getActor()).$close();
        } else {
            ((Actor)this.self()).$close();
        }
    }

    public Future $sync() {
        return new Promise<String>("void");
    }

    @CallerSideMethod
    public void __addStopHandler(Callback<SELF> cb) {
        if (this.__stopHandlers == null) {
            ((Actor)this.getActor()).__stopHandlers = this.getActorRef().__stopHandlers = new ConcurrentLinkedQueue();
        }
        this.__stopHandlers.add(cb);
    }

    @CallerSideMethod
    public void __addRemoteConnection(RemoteConnection con) {
        if (this.__connections == null) {
            ((Actor)this.getActor()).__connections = this.getActorRef().__connections = new ConcurrentLinkedQueue();
        }
        this.__connections.add(con);
    }

    @CallerSideMethod
    public void __removeRemoteConnection(RemoteConnection con) {
        if (this.__connections != null) {
            this.__connections.remove(con);
        }
    }

    @CallerSideMethod
    public void __stop() {
        if (this.getActorRef().isStopped() && ((Actor)this.getActor()).isStopped()) {
            return;
        }
        this.getActorRef().__stopped = true;
        ((Actor)this.getActor()).__stopped = true;
        if (this.__stopHandlers != null) {
            this.__stopHandlers.forEach((Consumer<Callback<SELF>>)((Consumer<Callback>)cb -> cb.receive(this.self(), null)));
            this.__stopHandlers.clear();
        }
        throw ActorStoppedException.Instance;
    }

    @CallerSideMethod
    public Object __enqueueCall(Actor receiver, String methodName, Object[] args) {
        if (this.__stopped) {
            if (methodName.equals("$stop")) {
                return null;
            }
            String senderString = sender.get() == null ? "null" : sender.get().getClass().getName();
            String s = "DEAD LETTER: sender:" + senderString + " receiver::msg:" + receiver.getClass().getSimpleName() + "::" + methodName;
            s = s.replace("_ActorProxy", "");
            Actors.AddDeadLetter(s);
        }
        return this.__scheduler.enqueueCall(sender.get(), receiver, methodName, args);
    }

    @CallerSideMethod
    public Method __getCachedMethod(String methodName, Actor actor) {
        Method method = this.methodCache.get(methodName);
        if (method == null) {
            Method[] methods = actor.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(methodName)) continue;
                this.methodCache.put(methodName, m);
                method = m;
                break;
            }
        }
        return method;
    }
}

