/*
 * Decompiled with CFR 0.152.
 */
package io.jaq.mpsc;

import io.jaq.mpsc.MpscConcurrentArrayQueueL3Pad;
import io.jaq.util.UnsafeAccess;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public final class MpscConcurrentQueue<E>
extends MpscConcurrentArrayQueueL3Pad<E>
implements Queue<E> {
    public MpscConcurrentQueue(int capacity) {
        super(capacity);
    }

    private long getHeadV() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, HEAD_OFFSET);
    }

    private void lazySetHead(long l) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, l);
    }

    private long getTail() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, TAIL_OFFSET);
    }

    private boolean casTail(long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, TAIL_OFFSET, expect, newValue);
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Channel is full");
    }

    private long elementOffsetInBuffer(long index) {
        return ARRAY_BASE + ((index & this.mask) << ELEMENT_SHIFT);
    }

    @Override
    public boolean offer(E e) {
        long currentTail;
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        do {
            currentTail = this.getTail();
            long wrapPoint = currentTail - (long)this.capacity;
            if (this.getHeadV() > wrapPoint) continue;
            return false;
        } while (!this.casTail(currentTail, currentTail + 1L));
        UnsafeAccess.UNSAFE.putOrderedObject(this.buffer, this.elementOffsetInBuffer(currentTail), e);
        return true;
    }

    public int offerStatus(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        long currentTail = this.getTail();
        long wrapPoint = currentTail - (long)this.capacity;
        if (this.getHeadV() <= wrapPoint) {
            return 1;
        }
        if (!this.casTail(currentTail, currentTail + 1L)) {
            return -1;
        }
        UnsafeAccess.UNSAFE.putOrderedObject(this.buffer, this.elementOffsetInBuffer(currentTail), e);
        return 0;
    }

    @Override
    public E poll() {
        long offset = this.elementOffsetInBuffer(this.head);
        Object e = UnsafeAccess.UNSAFE.getObjectVolatile(this.buffer, offset);
        if (null == e) {
            return null;
        }
        UnsafeAccess.UNSAFE.putObject(this.buffer, offset, null);
        this.lazySetHead(this.head + 1L);
        return (E)e;
    }

    @Override
    public E remove() {
        E e = this.poll();
        if (null == e) {
            throw new NoSuchElementException("Channel is empty");
        }
        return e;
    }

    @Override
    public E element() {
        E e = this.peek();
        if (null == e) {
            throw new NoSuchElementException("Channel is empty");
        }
        return e;
    }

    @Override
    public E peek() {
        long currentHead = this.getHeadV();
        return this.getElement(currentHead);
    }

    private E getElement(long index) {
        return (E)UnsafeAccess.UNSAFE.getObject(this.buffer, this.elementOffsetInBuffer(index));
    }

    @Override
    public int size() {
        return (int)(this.getTail() - this.getHeadV());
    }

    @Override
    public boolean isEmpty() {
        return this.getTail() == this.getHeadV();
    }

    @Override
    public boolean contains(Object o) {
        if (null == o) {
            return false;
        }
        long limit = this.getTail();
        for (long i = this.getHeadV(); i < limit; ++i) {
            E e = this.getElement(i);
            if (!o.equals(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        E value;
        while (null != (value = this.poll())) {
        }
    }
}

