/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.kontraktor.impl;

import de.ruedigermoeller.kontraktor.Actor;
import de.ruedigermoeller.kontraktor.ActorProxy;
import de.ruedigermoeller.kontraktor.Future;
import de.ruedigermoeller.kontraktor.Message;
import de.ruedigermoeller.kontraktor.MessageSequence;
import de.ruedigermoeller.kontraktor.impl.DispatcherThread;
import java.lang.reflect.Method;
import java.util.Arrays;

public class CallEntry<T>
implements Message<T> {
    private final T target;
    private final Method method;
    private final Object[] args;
    private Future futureCB;
    private DispatcherThread dispatcher;

    public CallEntry(T actor, Method method, Object[] args, DispatcherThread disp) {
        this.target = actor;
        this.method = method;
        this.args = args;
        this.dispatcher = disp;
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public DispatcherThread getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public Future send() {
        return DispatcherThread.pollDispatchOnObject(DispatcherThread.getThreadDispatcher(), this);
    }

    @Override
    public Future send(T target) {
        return this.withTarget(target, true).send();
    }

    @Override
    public Future yield(T ... targets) {
        return new MessageSequence(this, targets).yield();
    }

    @Override
    public Future exec(T ... targets) {
        return new MessageSequence(this, targets).exec();
    }

    @Override
    public Message copy() {
        return this.withTarget(this.target, true);
    }

    @Override
    public Message withTarget(T newTarget) {
        return this.withTarget(this.target, false);
    }

    @Override
    public Message withTarget(T newTarget, boolean copyArgs) {
        DispatcherThread newDispatcher = this.dispatcher;
        if (newTarget instanceof ActorProxy) {
            newTarget = ((ActorProxy)newTarget).getActor();
        }
        if (newTarget instanceof Actor) {
            newDispatcher = ((Actor)newTarget).getDispatcher();
        }
        if (copyArgs) {
            Object[] argCopy = new Object[this.args.length];
            System.arraycopy(this.args, 0, argCopy, 0, this.args.length);
            return new CallEntry<T>(newTarget, this.method, argCopy, newDispatcher);
        }
        return new CallEntry<T>(newTarget, this.method, this.args, newDispatcher);
    }

    public boolean hasFutureResult() {
        return this.method.getReturnType() == Future.class;
    }

    public void setFutureCB(Future futureCB) {
        this.futureCB = futureCB;
    }

    public Future getFutureCB() {
        return this.futureCB;
    }

    public String toString() {
        return "CallEntry{target=" + this.target + ", method=" + this.method + ", args=" + Arrays.toString(this.args) + ", futureCB=" + this.futureCB + ", dispatcher=" + this.dispatcher + '}';
    }
}

