/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.kontraktor.impl;

import de.ruedigermoeller.kontraktor.Actor;
import de.ruedigermoeller.kontraktor.ActorProxy;
import de.ruedigermoeller.kontraktor.Callback;
import de.ruedigermoeller.kontraktor.Future;
import de.ruedigermoeller.kontraktor.annotations.CallerSideMethod;
import de.ruedigermoeller.kontraktor.impl.DispatcherThread;
import java.io.Externalizable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Loader;
import javassist.NotFoundException;

public class ActorProxyFactory {
    HashMap<String, Class> generatedProxyClasses = new HashMap();

    public <T> T instantiateProxy(Actor target) {
        try {
            Object instance;
            block6: {
                Class<?> proxyClass = this.createProxyClass(target.getClass());
                Constructor<?>[] constructors = proxyClass.getConstructors();
                instance = null;
                try {
                    instance = proxyClass.newInstance();
                }
                catch (Exception e) {
                    for (int i = 0; i < constructors.length; ++i) {
                        Constructor<?> constructor = constructors[i];
                        if (constructor.getParameterTypes().length == 0) {
                            constructor.setAccessible(true);
                            instance = constructor.newInstance(new Object[0]);
                            break;
                        }
                        if (constructor.getParameterTypes().length != 1) continue;
                        instance = constructor.newInstance(new Object[]{null});
                        break;
                    }
                    if (instance != null) break block6;
                    throw e;
                }
            }
            Field f = instance.getClass().getField("__target");
            f.setAccessible(true);
            f.set(instance, target);
            return (T)instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Class<T> createProxyClass(Class<T> clazz) throws Exception {
        HashMap<String, Class> hashMap = this.generatedProxyClasses;
        synchronized (hashMap) {
            String proxyName = clazz.getName() + "_ActorProxy";
            String key = clazz.getName();
            Class ccClz = this.generatedProxyClasses.get(key);
            if (ccClz == null) {
                ClassPool pool = ClassPool.getDefault();
                CtClass cc = null;
                try {
                    cc = pool.getCtClass(proxyName);
                }
                catch (NotFoundException ex) {
                    // empty catch block
                }
                if (cc == null) {
                    cc = pool.makeClass(proxyName);
                    CtClass orig = pool.get(clazz.getName());
                    cc.setSuperclass(orig);
                    cc.setInterfaces(new CtClass[]{pool.get(Externalizable.class.getName()), pool.get(ActorProxy.class.getName())});
                    this.defineProxyFields(pool, cc);
                    this.defineProxyMethods(cc, orig);
                }
                ccClz = this.loadProxyClass(clazz, pool, cc);
                this.generatedProxyClasses.put(key, ccClz);
            }
            return ccClz;
        }
    }

    protected <T> Class loadProxyClass(Class clazz, ClassPool pool, final CtClass cc) throws ClassNotFoundException {
        Loader cl = new Loader(clazz.getClassLoader(), pool){

            protected Class loadClassByDelegation(String name) throws ClassNotFoundException {
                if (name.equals(cc.getName())) {
                    return null;
                }
                return this.delegateToParent(name);
            }
        };
        Class ccClz = cl.loadClass(cc.getName());
        return ccClz;
    }

    protected void defineProxyFields(ClassPool pool, CtClass cc) throws CannotCompileException, NotFoundException {
        CtField target = new CtField(pool.get(cc.getSuperclass().getName()), "__target", cc);
        target.setModifiers(1);
        cc.addField(target);
    }

    protected void defineProxyMethods(CtClass cc, CtClass orig) throws Exception {
        cc.addMethod(CtMethod.make((String)("public void __setDispatcher( " + DispatcherThread.class.getName() + " d ) { __target.__dispatcher(d); }"), (CtClass)cc));
        CtMethod[] methods = this.getSortedPublicCtMethods(orig, false);
        for (int i = 0; i < methods.length; ++i) {
            ClassMap map;
            CtMethod method;
            CtMethod originalMethod = method = methods[i];
            if (method.getName().equals("getActor")) {
                map = new ClassMap();
                map.put(Actor.class.getName(), Actor.class.getName());
                method = CtMethod.make((String)("public " + Actor.class.getName() + " getActor() { return __target; }"), (CtClass)cc);
            } else {
                map = new ClassMap();
                map.fix(orig);
                method = new CtMethod(method, cc, map);
            }
            CtClass returnType = method.getReturnType();
            boolean isCallerSide = originalMethod.getAnnotation(CallerSideMethod.class) != null || originalMethod.getName().equals("self") || originalMethod.getName().equals("future");
            boolean allowed = (method.getModifiers() & 0x400) == 0 && (method.getModifiers() & 0x118) == 0 && (method.getModifiers() & 1) != 0 && !isCallerSide;
            allowed &= !originalMethod.getDeclaringClass().getName().equals(Object.class.getName()) && !originalMethod.getDeclaringClass().getName().equals(Actor.class.getName());
            if (originalMethod.getName().equals("executeInActorThread")) {
                allowed = true;
            }
            if (allowed) {
                boolean isVoid;
                boolean bl = isVoid = returnType == CtPrimitiveType.voidType;
                if (returnType != CtPrimitiveType.voidType && !returnType.getName().equals(Future.class.getName())) {
                    throw new RuntimeException("only void methods or methods returning Future allowed");
                }
                String conversion = "";
                Object[][] availableParameterAnnotations = originalMethod.getAvailableParameterAnnotations();
                CtClass[] parameterTypes = originalMethod.getParameterTypes();
                block1: for (int j = 0; j < availableParameterAnnotations.length; ++j) {
                    Object[] availableParameterAnnotation = availableParameterAnnotations[j];
                    if (availableParameterAnnotation.length <= 0) continue;
                    for (int k = 0; k < availableParameterAnnotation.length; ++k) {
                        Object annot = availableParameterAnnotation[k];
                        if (annot.toString().indexOf("kontraktor.annotations.InThread") <= 0) continue;
                        if (parameterTypes[j].getName().equals(Callback.class.getName())) {
                            System.out.println("InThread unnecessary when using built in Callback class");
                            continue;
                        }
                        if (!parameterTypes[j].isInterface()) {
                            throw new RuntimeException("@InThread can be used on interfaces only");
                        }
                        conversion = conversion + "args[" + j + "] = de.ruedigermoeller.kontraktor.Actors.InThread(args[" + j + "]);";
                        continue block1;
                    }
                }
                String call = "__target.__dispatchCall( this, \"" + method.getName() + "\", args );";
                if (!isVoid) {
                    call = "return (" + originalMethod.getReturnType().getName() + ") (Object)" + call;
                }
                String body = "{ Object args[] = $args;" + conversion + call + "}";
                method.setBody(body);
                cc.addMethod(method);
                continue;
            }
            if ((method.getModifiers() & 0x118) != 0 || isCallerSide || method.getName().equals("toString")) continue;
            if (method.getName().equals("getDispatcher")) {
                method.setBody(" return __target.getDispatcher();");
                cc.addMethod(method);
                continue;
            }
            if (!method.getName().equals("getActor")) {
                method.setBody("throw new RuntimeException(\"can only call public methods on actor ref\");");
                cc.addMethod(method);
                continue;
            }
            cc.addMethod(method);
        }
    }

    public String toString(Method m) {
        try {
            StringBuilder sb = new StringBuilder();
            int mod = m.getModifiers() & Modifier.methodModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod)).append(' ');
            }
            sb.append(m.getReturnType()).append(' ');
            sb.append(m.getName()).append('(');
            Class<?>[] params = m.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(params[j].toString());
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public String toString(CtMethod m) {
        try {
            StringBuilder sb = new StringBuilder();
            int mod = m.getModifiers() & Modifier.methodModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod)).append(' ');
            }
            sb.append(m.getReturnType().getName()).append(' ');
            sb.append(m.getName()).append('(');
            CtClass[] params = m.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(params[j].getName());
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    protected CtMethod[] getSortedPublicCtMethods(CtClass orig, boolean onlyRemote) throws NotFoundException {
        CtMethod method;
        int count = 0;
        CtMethod[] methods0 = orig.getMethods();
        HashSet<String> alreadypresent = new HashSet<String>();
        HashSet<String> unqiqueForActors = new HashSet<String>();
        for (int i = methods0.length - 1; i >= 0; --i) {
            CtMethod method2 = methods0[i];
            String str = this.toString(method2);
            if (alreadypresent.contains(str) || method2.getName().startsWith("access$")) {
                methods0[i] = null;
                continue;
            }
            String key = method2.getName();
            if (unqiqueForActors.contains(key) && !method2.getDeclaringClass().getName().equals("java.lang.Object")) {
                throw new RuntimeException("method overloading not supported for actors.");
            }
            unqiqueForActors.add(key);
            alreadypresent.add(str);
        }
        CtMethod[] methods = null;
        if (onlyRemote) {
            int i;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if (method == null || (method.getModifiers() & 1) == 0) continue;
                ++count;
            }
            methods = new CtMethod[count];
            count = 0;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if ((method.getModifiers() & 1) == 0) continue;
                methods[count++] = method;
            }
        } else {
            int i;
            count = 0;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if (method == null) continue;
                ++count;
            }
            methods = new CtMethod[count];
            count = 0;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if (method == null) continue;
                methods[count++] = method;
            }
        }
        Arrays.sort(methods, new Comparator<CtMethod>(){

            @Override
            public int compare(CtMethod o1, CtMethod o2) {
                try {
                    return (o1.getName() + o1.getReturnType() + o1.getParameterTypes().length).compareTo(o2.getName() + o2.getReturnType() + o2.getParameterTypes().length);
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
        return methods;
    }
}

