/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.kontraktor;

import de.ruedigermoeller.kontraktor.Callback;
import de.ruedigermoeller.kontraktor.Filter;
import de.ruedigermoeller.kontraktor.Future;
import de.ruedigermoeller.kontraktor.impl.CallbackWrapper;
import de.ruedigermoeller.kontraktor.impl.DispatcherThread;
import java.util.concurrent.atomic.AtomicBoolean;

public class Promise<T>
implements Future<T> {
    protected Object result;
    protected Object error;
    protected Callback resultReceiver;
    protected boolean hadResult;
    protected boolean hasFired = false;
    AtomicBoolean lock = new AtomicBoolean(false);
    Thread currentThread = Thread.currentThread();
    String id;
    Future nextFuture;

    public Promise(T result, Object error) {
        this.result = result;
        this.error = error;
        this.hadResult = true;
    }

    public Promise(T result) {
        this(result, null);
    }

    public Promise() {
    }

    public String getId() {
        return this.id;
    }

    public Promise<T> setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public <OUT> Future<OUT> filter(final Filter<T, OUT> filter) {
        final Promise<T> promise = new Promise<T>();
        this.then(new Callback<T>(){

            @Override
            public void receiveResult(T result, Object error) {
                filter.filter(result, error).then(promise);
            }
        });
        return promise;
    }

    @Override
    public Future then(Callback resultCB) {
        while (!this.lock.compareAndSet(false, true)) {
        }
        this.resultReceiver = resultCB;
        if (this.hadResult) {
            if (this.hasFired) {
                this.lock.set(false);
                throw new RuntimeException("Double result received on future");
            }
            this.hasFired = true;
            this.lock.set(false);
            resultCB.receiveResult(this.result, this.error);
            this.nextFuture = new Promise<Object>(this.result, this.error);
            return this.nextFuture;
        }
        this.lock.set(false);
        if (resultCB instanceof Future) {
            return (Future)resultCB;
        }
        this.nextFuture = new Promise<T>();
        return this.nextFuture;
    }

    @Override
    public void receiveResult(Object res, Object error) {
        if (Thread.currentThread() != this.currentThread && this.currentThread instanceof DispatcherThread) {
            new CallbackWrapper<Object>((DispatcherThread)this.currentThread, this).receiveResult(res, error);
        } else {
            this.result = res;
            this.error = error;
            while (!this.lock.compareAndSet(false, true)) {
            }
            this.hadResult = true;
            if (this.resultReceiver != null) {
                if (this.hasFired) {
                    this.lock.set(false);
                    throw new RuntimeException("Double result received on future");
                }
                this.hasFired = true;
                this.lock.set(false);
                this.resultReceiver.receiveResult(this.result, error);
                this.resultReceiver = null;
                if (this.nextFuture != null) {
                    this.nextFuture.receiveResult(this.result, error);
                }
                return;
            }
            this.lock.set(false);
        }
    }

    @Override
    public T getResult() {
        return (T)this.result;
    }

    public Object getError() {
        return this.error;
    }

    public String toString() {
        return "Result{result=" + this.result + ", error=" + this.error + '}';
    }
}

