/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.kontraktor;

import de.ruedigermoeller.kontraktor.Actors;
import de.ruedigermoeller.kontraktor.Callback;
import de.ruedigermoeller.kontraktor.Future;
import de.ruedigermoeller.kontraktor.Message;
import de.ruedigermoeller.kontraktor.Promise;
import java.util.ArrayList;
import java.util.List;

public class MessageSequence {
    List<Message> messages;

    public MessageSequence(Message msg, Object ... targets) {
        this.messages = new ArrayList<Message>();
        for (int i = 0; i < targets.length; ++i) {
            Object target = targets[i];
            this.messages.add(msg.withTarget(target, true));
        }
    }

    public MessageSequence(List<Message> messages) {
        this.messages = messages;
        for (int i = 0; i < messages.size(); ++i) {
            Message message = messages.get(i);
        }
    }

    public Future<Future[]> yield() {
        Future[] res = new Future[this.messages.size()];
        for (int i = 0; i < this.messages.size(); ++i) {
            Message message = this.messages.get(i);
            if (message.getMethod().getReturnType() == Void.TYPE) {
                res[i] = new Promise<String>("void");
                message.send();
                continue;
            }
            res[i] = message.send();
        }
        return Actors.Yield(res);
    }

    public int size() {
        return this.messages.size();
    }

    public Message get(int index) {
        return this.messages.get(index);
    }

    public Message first() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    public Future<Future[]> exec() {
        Promise<Future[]> promise = new Promise<Future[]>();
        Future[] res = new Future[this.messages.size()];
        this.exec(res, 0, promise);
        return promise;
    }

    private void exec(final Future[] res, final int index, final Callback finished) {
        if (index >= res.length) {
            finished.receiveResult(res, null);
            return;
        }
        res[index] = this.messages.get(index).send();
        res[index].then(new Callback(){

            public void receiveResult(Object result, Object error) {
                if (error != null) {
                    finished.receiveResult(res, error);
                    return;
                }
                MessageSequence.this.exec(res, index + 1, finished);
            }
        });
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public String toString() {
        return "MessageSequence{messages=" + this.messages + '}';
    }
}

