/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.kontraktor;

import de.ruedigermoeller.kontraktor.ActorRunnable;
import de.ruedigermoeller.kontraktor.Actors;
import de.ruedigermoeller.kontraktor.Callback;
import de.ruedigermoeller.kontraktor.Future;
import de.ruedigermoeller.kontraktor.Message;
import de.ruedigermoeller.kontraktor.MessageSequence;
import de.ruedigermoeller.kontraktor.annotations.CallerSideMethod;
import de.ruedigermoeller.kontraktor.impl.ActorProxyFactory;
import de.ruedigermoeller.kontraktor.impl.CallEntry;
import de.ruedigermoeller.kontraktor.impl.CallbackWrapper;
import de.ruedigermoeller.kontraktor.impl.DispatcherThread;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class Actor<SELF extends Actor> {
    static ThreadLocal<List<Message>> methodSequence = new ThreadLocal<List<Message>>(){

        @Override
        protected List<Message> initialValue() {
            return new ArrayList<Message>();
        }
    };
    public Actor __self;
    public Actor __seq;
    public boolean __isSeq = false;
    DispatcherThread __dispatcher;
    protected ConcurrentHashMap<String, Method> methodCache = new ConcurrentHashMap();

    public static MessageSequence currentSequence() {
        List<Message> res = methodSequence.get();
        methodSequence.set(new ArrayList());
        return new MessageSequence(res);
    }

    public static Message currentMsg() {
        return Actor.currentSequence().first();
    }

    public static Message msg(Future call) {
        return Actor.currentSequence().first();
    }

    public static MessageSequence seq(Future ... calls) {
        List<Message> res = methodSequence.get();
        methodSequence.set(new ArrayList());
        return new MessageSequence(res);
    }

    public DispatcherThread getDispatcher() {
        if (this.__self == null && this.getActor() != this) {
            return ((Actor)this.getActor()).getDispatcher();
        }
        return this.__dispatcher;
    }

    protected SELF self() {
        return (SELF)this.__self;
    }

    public SELF $() {
        return (SELF)this.__seq;
    }

    public ActorProxyFactory getFactory() {
        return Actors.instance.getFactory();
    }

    public SELF getActor() {
        return (SELF)this;
    }

    @CallerSideMethod
    public void stop() {
        this.getDispatcher().actorStopped(this);
    }

    public void executeInActorThread(ActorRunnable toRun, Callback cb) {
        toRun.run(this.getActorAccess(), (Actor)this.getActor(), cb);
    }

    protected Object getActorAccess() {
        return null;
    }

    public boolean isProxy() {
        return this.getActor() != this;
    }

    protected Future<Future[]> yield(Future ... futures) {
        return Actors.Yield(futures);
    }

    @CallerSideMethod
    public void __dispatcher(DispatcherThread d) {
        this.__dispatcher = d;
    }

    @CallerSideMethod
    public Object __dispatchCall(Actor receiver, String methodName, Object[] args) {
        SELF actor = receiver.getActor();
        Method method = this.getCachedMethod(methodName, (Actor)actor);
        boolean count = false;
        DispatcherThread threadDispatcher = DispatcherThread.getThreadDispatcher();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof Callback)) continue;
            DispatcherThread sender = threadDispatcher;
            args[i] = new CallbackWrapper(sender, (Callback)arg);
        }
        CallEntry<SELF> e = new CallEntry<SELF>(actor, method, args, ((Actor)actor).getDispatcher());
        if (receiver.__isSeq) {
            methodSequence.get().add(e);
            return null;
        }
        return DispatcherThread.pollDispatchOnObject(threadDispatcher, e);
    }

    private Method getCachedMethod(String methodName, Actor actor) {
        Method method = this.methodCache.get(methodName);
        if (method == null) {
            Method[] methods = actor.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(methodName)) continue;
                this.methodCache.put(methodName, m);
                method = m;
                break;
            }
        }
        return method;
    }
}

