/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.reactivestreams.impl;

import java.util.function.Function;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.reactivestreams.KxPublisher;
import org.nustaq.kontraktor.reactivestreams.KxReactiveStreams;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SyncProcessor<IN, OUT>
implements Processor<IN, OUT>,
KxPublisher<OUT> {
    protected Subscription inSubs;
    protected Subscription outSubs;
    protected Subscriber<OUT> subscriber;
    protected boolean done = false;
    protected long batchSize;
    protected Function<IN, OUT> proc;
    protected long initialRequest = 0L;
    protected KxReactiveStreams streams;

    public SyncProcessor(long batchSize, Function<IN, OUT> proc, KxReactiveStreams streams) {
        this.streams = streams;
        this.batchSize = batchSize;
        this.proc = proc;
    }

    public void onSubscribe(Subscription s) {
        if (s == null) {
            throw null;
        }
        if (this.inSubs != null) {
            s.cancel();
            return;
        }
        this.inSubs = s;
        if (this.initialRequest > 0L) {
            s.request(this.initialRequest);
        }
    }

    public void onNext(IN element) {
        if (this.done) {
            return;
        }
        if (element == null) {
            throw null;
        }
        try {
            this.subscriber.onNext(this.process(element));
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    protected OUT process(IN element) {
        return this.proc.apply(element);
    }

    public void onError(Throwable t) {
        if (this.subscriber != null) {
            this.subscriber.onError(t);
        } else {
            t.printStackTrace();
        }
    }

    public void onComplete() {
        this.done = true;
        this.subscriber.onComplete();
    }

    @Override
    public void subscribe(Subscriber<? super OUT> s) {
        if (this.subscriber != null) {
            throw new RuntimeException("can only subscribe once");
        }
        this.subscriber = s;
        this.outSubs = new MySubs();
        s.onSubscribe(this.outSubs);
    }

    @Override
    @CallerSideMethod
    public KxReactiveStreams getKxStreamsInstance() {
        return this.streams;
    }

    protected class MySubs
    implements Subscription {
        protected MySubs() {
        }

        public void request(long n) {
            if (n <= 0L) {
                SyncProcessor.this.subscriber.onError((Throwable)new IllegalArgumentException("rule 3.9: request > 0 elements"));
                return;
            }
            if (SyncProcessor.this.inSubs != null) {
                SyncProcessor.this.inSubs.request(n);
            } else {
                SyncProcessor.this.initialRequest = n;
            }
        }

        public void cancel() {
            SyncProcessor.this.inSubs.cancel();
            SyncProcessor.this.subscriber = null;
        }
    }
}

