/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ActorServer;
import org.nustaq.kontraktor.remoting.base.ActorServerConnector;
import org.nustaq.kontraktor.remoting.base.ObjectSink;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.kontraktor.remoting.base.SessionResurrector;
import org.nustaq.kontraktor.remoting.base.TrafficMonitor;
import org.nustaq.kontraktor.remoting.http.ConnectionAuthResult;
import org.nustaq.kontraktor.remoting.http.HttpObjectSocket;
import org.nustaq.kontraktor.remoting.http.KHttpExchange;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.utils.TrafficMonitorUtil;

public abstract class AbstractHttpServerConnector
implements ActorServerConnector {
    public static int REQUEST_RESULTING_FUTURE_TIMEOUT = 3000;
    public static long SESSION_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(30L);
    public static long IDLE_SESSION_TIMEOUT_MS = TimeUnit.HOURS.toMillis(12L);
    protected Actor facade;
    protected HashMap<String, HttpObjectSocket> sessions = new HashMap();
    protected FSTConfiguration conf = FSTConfiguration.createJsonConfiguration((boolean)false, (boolean)false);
    protected Function<ObjectSocket, ObjectSink> factory;
    protected long sessionTimeout = SESSION_TIMEOUT_MS;
    private long idleSessionTimeout = IDLE_SESSION_TIMEOUT_MS;
    protected volatile boolean isClosed = false;
    protected ActorServer actorServer;
    protected Function<KHttpExchange, ConnectionAuthResult> connectionVerifier;
    protected TrafficMonitor trafficMonitor;

    public AbstractHttpServerConnector(Actor facade) {
        this.facade = facade;
        facade.delayed((long)(HttpObjectSocket.LP_TIMEOUT / 2), () -> this.houseKeeping());
    }

    public void houseKeeping() {
        long now = System.currentTimeMillis();
        ArrayList<String> toRemove = new ArrayList<String>(0);
        this.sessions.entrySet().forEach(entry -> {
            HttpObjectSocket socket = (HttpObjectSocket)entry.getValue();
            if (now - socket.getLongPollTaskTime() >= (long)(HttpObjectSocket.LP_TIMEOUT / 2)) {
                socket.triggerLongPoll();
            }
            if (now - socket.getLastUse() > this.getSessionTimeout() || now - socket.getLastRemoteCallMS() > this.getIdleSessionTimeout()) {
                socket.triggerLongPoll();
                toRemove.add((String)entry.getKey());
            }
        });
        toRemove.forEach(sessionId -> this.closeSession((String)sessionId));
        if (!this.isClosed) {
            this.facade.delayed((long)(HttpObjectSocket.LP_TIMEOUT / 4), () -> this.houseKeeping());
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    protected HttpObjectSocket restoreSessionFromId(String sessionId) {
        if (this.facade instanceof SessionResurrector) {
            HttpObjectSocket sock = new HttpObjectSocket(sessionId, () -> this.facade.execute(() -> this.closeSession(sessionId))){

                @Override
                protected int getObjectMaxBatchSize() {
                    return HttpObjectSocket.HTTP_BATCH_SIZE;
                }

                @Override
                public String getConnectionIdentifier() {
                    return this.sessionId;
                }
            };
            this.sessions.put(sock.getSessionId(), sock);
            ObjectSink sink = this.factory.apply(sock);
            sock.setSink(sink);
            return sock;
        }
        return null;
    }

    public Function<KHttpExchange, ConnectionAuthResult> getConnectionVerifier() {
        return this.connectionVerifier;
    }

    public void setConnectionVerifier(Function<KHttpExchange, ConnectionAuthResult> connectionVerifier) {
        this.connectionVerifier = connectionVerifier;
    }

    protected void handleNewSession(KHttpExchange exchange) {
        String sessionId = null;
        if (this.connectionVerifier != null) {
            ConnectionAuthResult denialReason = this.connectionVerifier.apply(exchange);
            if (denialReason == null || denialReason.isError()) {
                exchange.setResponseCode(403);
                exchange.send(denialReason != null ? denialReason.getError() : "expected ConnectionAuthResult, got null");
                exchange.endExchange();
                return;
            }
            sessionId = denialReason.getSid();
        } else {
            sessionId = UUID.randomUUID().toString();
        }
        String finalSessionId = sessionId;
        HttpObjectSocket sock = new HttpObjectSocket(sessionId, () -> this.facade.execute(() -> this.closeSession(finalSessionId))){

            @Override
            protected int getObjectMaxBatchSize() {
                return HttpObjectSocket.HTTP_BATCH_SIZE;
            }

            @Override
            public String getConnectionIdentifier() {
                return this.sessionId;
            }
        };
        this.sessions.put(sock.getSessionId(), sock);
        ObjectSink sink = this.factory.apply(sock);
        sock.setSink(sink);
        byte[] response = this.conf.asByteArray((Object)sock.getSessionId());
        TrafficMonitorUtil.monitorTraffic(this.trafficMonitor, sessionId, "out", exchange.getPath(), response.length);
        exchange.sendAuthResponse(response, sessionId);
    }

    protected HttpObjectSocket closeSession(String sessionId) {
        Log.Info((Object)this, (String)(sessionId + " closed"));
        HttpObjectSocket httpObjectSocket = this.sessions.get(sessionId);
        if (httpObjectSocket != null) {
            httpObjectSocket.sinkClosed();
        }
        return this.sessions.remove(sessionId);
    }

    public void connect(Actor facade, Function<ObjectSocket, ObjectSink> factory) throws Exception {
        this.facade = facade;
        this.factory = factory;
    }

    public IPromise closeServer() {
        this.isClosed = true;
        return new Promise(null);
    }

    public void setActorServer(ActorServer actorServer) {
        this.actorServer = actorServer;
    }

    public ActorServer getActorServer() {
        return this.actorServer;
    }

    public long getIdleSessionTimeout() {
        return this.idleSessionTimeout;
    }

    public void setIdleSessionTimeout(long idleSessionTimeout) {
        this.idleSessionTimeout = idleSessionTimeout;
    }

    public void setTrafficMonitor(TrafficMonitor trafficMonitor) {
        this.trafficMonitor = trafficMonitor;
    }
}

