/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.websockets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.util.FSTUtil;

public abstract class WebObjectSocket
implements ObjectSocket {
    protected List objects;
    protected FSTConfiguration conf;
    protected Throwable lastError;
    protected AtomicInteger sendSequence = new AtomicInteger(0);
    protected volatile boolean isClosed;
    Thread debugT;
    boolean DBGTHREADS = false;
    AtomicInteger debugCount = new AtomicInteger();

    public AtomicInteger getSendSequence() {
        return this.sendSequence;
    }

    public WebObjectSocket() {
        this.objects = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object toWrite) throws Exception {
        if (this.DBGTHREADS) {
            if (this.debugT != null && this.debugT != Thread.currentThread()) {
                System.out.println("Thread " + Thread.currentThread().getName() + " other " + this.debugT.getName());
                System.out.println("writing object:" + toWrite);
                if (Thread.currentThread().getName().indexOf("Dispatch") < 0) {
                    boolean bl = true;
                }
                this.debugT = Thread.currentThread();
            }
            this.debugT = Thread.currentThread();
        }
        WebObjectSocket webObjectSocket = this;
        synchronized (webObjectSocket) {
            this.objects.add(toWrite);
            if (this.objects.size() > this.getObjectMaxBatchSize()) {
                this.flush();
            }
        }
    }

    protected int getObjectMaxBatchSize() {
        return 500;
    }

    public abstract void sendBinary(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        if (this.DBGTHREADS && this.debugT != null && this.debugT != Thread.currentThread()) {
            System.out.println("flush Thread " + Thread.currentThread().getName() + " other " + this.debugT.getName());
            if (Thread.currentThread().getName().indexOf("Dispatch") < 0) {
                boolean bl = true;
            }
            this.debugT = Thread.currentThread();
        }
        WebObjectSocket webObjectSocket = this;
        synchronized (webObjectSocket) {
            if (this.objects.size() == 0) {
                return;
            }
            if (this.isClosed()) {
                if (this.lastError != null) {
                    FSTUtil.rethrow((Throwable)this.lastError);
                } else {
                    throw new IOException("WebSocket is closed");
                }
            }
            this.objects.add(this.sendSequence.incrementAndGet());
            Object[] objArr = this.objects.toArray();
            this.objects.clear();
            this.debugCount.addAndGet(objArr.length);
            this.sendBinary(this.conf.asByteArray((Object)objArr));
        }
    }

    public void setLastError(Throwable ex) {
        this.lastError = ex;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void setConf(FSTConfiguration conf) {
        this.conf = conf;
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

