/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.javascript;

import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.util.DateUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class CachedFileResourceManager
extends FileResourceManager {
    Date lastStartup;

    public CachedFileResourceManager(boolean enableCaching, File base, long transferMinSize) {
        super(base, transferMinSize);
        this.lastStartup = enableCaching ? new Date() : null;
    }

    protected FileResource getFileResource(File file, String path) throws IOException {
        return new MyFileResource(file, this, path, this.lastStartup);
    }

    class MyFileResource
    extends FileResource {
        Date lastModified;

        public MyFileResource(File file, FileResourceManager manager, String path, Date lastStartUp) {
            super(file, manager, path);
            this.lastModified = lastStartUp;
        }

        public Date getLastModified() {
            if (this.lastModified == null) {
                return new Date();
            }
            return this.lastModified;
        }

        public String getLastModifiedString() {
            return DateUtils.toDateString((Date)this.getLastModified());
        }
    }
}

