/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.routing;

import java.io.File;
import java.io.Serializable;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.routing.RoutedServiceEntry;
import org.nustaq.kson.Kson;
import org.nustaq.utils.FileLookup;

public class WSKrouterStarterConfig
implements Serializable {
    String host = "localhost";
    int port = 6667;
    RoutedServiceEntry[] services = new RoutedServiceEntry[0];

    public static WSKrouterStarterConfig read() {
        File lookup = new FileLookup("wskrouter.kson").lookup();
        Kson kson = new Kson().map(new Class[]{RoutedServiceEntry.class}).map(new Class[]{WSKrouterStarterConfig.class});
        try {
            WSKrouterStarterConfig res = (WSKrouterStarterConfig)kson.readObject(lookup);
            return res;
        }
        catch (Exception e) {
            WSKrouterStarterConfig cfg = new WSKrouterStarterConfig();
            cfg.services = new RoutedServiceEntry[]{new RoutedServiceEntry("sample/v1/json", SerializerType.JsonNoRef)};
            try {
                String s = kson.writeObject((Object)cfg);
                System.out.println("wskrouter.kson not found, defaulting to ");
                System.out.println(s);
                return cfg;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public RoutedServiceEntry[] getServices() {
        return this.services;
    }

    public WSKrouterStarterConfig host(String host) {
        this.host = host;
        return this;
    }

    public WSKrouterStarterConfig port(int port) {
        this.port = port;
        return this;
    }

    public WSKrouterStarterConfig services(RoutedServiceEntry[] services) {
        this.services = services;
        return this;
    }

    public static void main(String[] args) {
        WSKrouterStarterConfig.read();
    }
}

