/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.transpiler.jsx;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

public class TimeStampedFileCache<T> {
    static Map<File, String> canonicalCache = new HashMap<File, String>();
    Map<String, T> cache = new HashMap<String, T>();

    public static String getCanonicalPath(File f) throws IOException {
        String s = canonicalCache.get(f);
        if (s != null) {
            return s;
        }
        String canonicalPath = null;
        canonicalPath = Files.isSymbolicLink(f.toPath()) ? f.getAbsolutePath() : f.getCanonicalPath();
        canonicalCache.put(f, canonicalPath);
        return canonicalPath;
    }

    public void put(File f, T result) {
        String key = this.getKey(f);
        this.cache.put(key, result);
    }

    public T get(File f) {
        return this.cache.get(this.getKey(f));
    }

    public String getKey(File f) {
        String path = null;
        try {
            path = TimeStampedFileCache.getCanonicalPath(f);
        }
        catch (IOException e) {
            path = f.getAbsolutePath();
        }
        return f.lastModified() + " " + path;
    }
}

