/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ActorPublisher;
import org.nustaq.kontraktor.remoting.base.ActorServer;
import org.nustaq.kontraktor.remoting.base.ActorServerConnector;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.http.ConnectionAuthResult;
import org.nustaq.kontraktor.remoting.http.KHttpExchange;
import org.nustaq.kontraktor.remoting.http.undertow.Http4K;
import org.nustaq.kontraktor.remoting.http.undertow.UndertowHttpServerConnector;
import org.nustaq.kontraktor.remoting.http.undertow.WebSocketPublisher;
import org.nustaq.kontraktor.remoting.http.undertow.builder.BldFourK;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.util.Pair;

public class HttpPublisher
implements ActorPublisher,
Cloneable {
    BldFourK cfg;
    String hostName;
    String urlPath;
    int port;
    Coding coding = new Coding(SerializerType.FSTSer);
    long sessionTimeout = TimeUnit.MINUTES.toMillis(30L);
    long idleSessionTimeout = TimeUnit.HOURS.toMillis(8L);
    Actor facade;
    private Function<KHttpExchange, ConnectionAuthResult> connectionVerifier;

    public HttpPublisher() {
    }

    public HttpPublisher(Actor actor, String hostName, String urlPath, int port) {
        this.hostName = hostName;
        this.urlPath = urlPath;
        this.port = port;
        this.facade = actor;
    }

    public HttpPublisher(BldFourK cfgFourK, Actor facade, String hostName, String urlPath, int port) {
        this(facade, hostName, urlPath, port);
        this.cfg = cfgFourK;
    }

    public HttpPublisher connectionVerifier(Function<KHttpExchange, ConnectionAuthResult> connectionVerifier) {
        this.connectionVerifier = connectionVerifier;
        return this;
    }

    public Function<KHttpExchange, ConnectionAuthResult> getConnectionVerifier() {
        return this.connectionVerifier;
    }

    public BldFourK buildHttpApi() {
        return this.cfg;
    }

    public WebSocketPublisher toWS() {
        return new WebSocketPublisher().coding(this.coding).facade(this.facade).hostName(this.hostName).port(this.port).urlPath(this.urlPath);
    }

    public IPromise<ActorServer> publish(Consumer<Actor> disconnectCallback) {
        ActorServer actorServer;
        try {
            Pair<PathHandler, Undertow> serverPair = Http4K.get().getServer(this.port, this.hostName);
            UndertowHttpServerConnector con = new UndertowHttpServerConnector(this.facade);
            con.setConnectionVerifier(this.connectionVerifier);
            con.setSessionTimeout(this.sessionTimeout);
            con.setIdleSessionTimeout(this.idleSessionTimeout);
            actorServer = new ActorServer((ActorServerConnector)con, this.facade, this.coding == null ? new Coding(SerializerType.FSTSer) : this.coding);
            con.setActorServer(actorServer);
            actorServer.start(disconnectCallback);
            ((PathHandler)serverPair.getFirst()).addPrefixPath(this.urlPath, (HttpHandler)con);
        }
        catch (Exception e) {
            Log.Warn(null, (Throwable)e);
            return new Promise(null, (Object)e);
        }
        return new Promise((Object)actorServer);
    }

    public HttpPublisher idleSessionTimeout(long idleSessionTimeout) {
        this.idleSessionTimeout = idleSessionTimeout;
        return this;
    }

    public long getIdleSessionTimeout() {
        return this.idleSessionTimeout;
    }

    public HttpPublisher hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public HttpPublisher urlPath(String urlPath) {
        this.urlPath = urlPath;
        return this;
    }

    public HttpPublisher port(int port) {
        this.port = port;
        return this;
    }

    public HttpPublisher coding(Coding coding) {
        this.coding = coding;
        return this;
    }

    public HttpPublisher serType(SerializerType tp) {
        return this.coding(new Coding(tp));
    }

    public HttpPublisher facade(Actor facade) {
        this.facade = facade;
        return this;
    }

    public HttpPublisher setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    protected HttpPublisher clone() throws CloneNotSupportedException {
        HttpPublisher clone = (HttpPublisher)super.clone();
        return clone;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public int getPort() {
        return this.port;
    }

    public Coding getCoding() {
        return this.coding;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Actor getFacade() {
        return this.facade;
    }
}

