/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.transpiler.jsx;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.webapp.transpiler.jsx.WatchedFile;

public class FileWatcher
extends Actor<FileWatcher> {
    static FileWatcher singleton;
    List<WatchedFile> watched = new ArrayList<WatchedFile>();
    boolean doStop = false;
    List<Callback> watchers = new ArrayList<Callback>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileWatcher get() {
        Class<FileWatcher> clazz = FileWatcher.class;
        synchronized (FileWatcher.class) {
            if (singleton == null) {
                singleton = (FileWatcher)FileWatcher.AsActor(FileWatcher.class);
                singleton.startWatching();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public void setFiles(List<WatchedFile> watched) {
        this.watched = watched;
    }

    public void stopWatching() {
        this.doStop = true;
        this.stop();
    }

    public IPromise addListener(Callback fileWatcher) {
        this.watchers.add(fileWatcher);
        return FileWatcher.resolve();
    }

    public void startWatching() {
        this.cyclic(30L, () -> {
            this.watched.forEach(watchedFile -> {
                Long l = watchedFile.getLastModified();
                if (l.longValue() != watchedFile.getFile().lastModified()) {
                    Log.Info((Object)((Object)this), (String)("File " + watchedFile.getFile().getAbsolutePath() + " was modified"));
                    watchedFile.updateTS();
                    watchedFile.transpiler.updateJSX(watchedFile.getFile(), watchedFile.resolver);
                    this.fireChange(watchedFile.getWebPath());
                }
            });
            return !this.doStop;
        });
    }

    private void fireChange(String webPath) {
        this.watchers = this.watchers.stream().filter(cb -> !cb.isTerminated()).collect(Collectors.toList());
        this.watchers.forEach(w -> w.pipe((Object)webPath));
    }
}

