/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.javascript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;

public class KUrl
implements Serializable {
    String protocol;
    String[] elements;
    boolean isTopDomain = false;
    boolean isTopRoot = false;

    public static String stripDoubleSeps(String url) {
        while (url.indexOf("//") > 0) {
            url = url.replace("//", "/");
        }
        return url;
    }

    public KUrl(String url) {
        int idx = url.indexOf("://");
        if (idx >= 0) {
            this.protocol = url.substring(0, idx);
            url = url.substring(idx + 3);
        }
        this.isTopRoot = url.startsWith("//");
        if (!this.isTopRoot) {
            this.isTopDomain = url.startsWith("/");
        }
        url = KUrl.stripDoubleSeps(url);
        this.elements = url.split("/");
        this.normalize();
    }

    public KUrl(String protocol, String[] elements) {
        this.protocol = protocol;
        this.elements = elements;
    }

    public KUrl(String[] elements) {
        this.elements = elements;
    }

    protected void normalize() {
        ArrayList<String> newElems = new ArrayList<String>();
        for (int i = 0; i < this.elements.length; ++i) {
            String element = this.elements[i].trim();
            if (element.length() <= 0 || element.equals(".")) continue;
            if (element.equals("..") && newElems.size() > 0 && !"..".equalsIgnoreCase((String)newElems.get(newElems.size() - 1))) {
                newElems.remove(newElems.size() - 1);
                continue;
            }
            newElems.add(element);
        }
        this.elements = new String[newElems.size()];
        newElems.toArray(this.elements);
    }

    public KUrl concat(String url) {
        return this.concat(new KUrl(url));
    }

    public KUrl concat(KUrl url) {
        String[] elems = url.getElements();
        if (url.isTopRoot) {
            return new KUrl(this.protocol, elems);
        }
        if (url.isTopDomain) {
            String[] newElems = new String[elems.length + 1];
            System.arraycopy(elems, 0, newElems, 1, elems.length);
            newElems[0] = this.elements[0];
            return new KUrl(this.protocol, newElems);
        }
        String[] newElems = new String[elems.length + this.elements.length];
        System.arraycopy(this.elements, 0, newElems, 0, this.elements.length);
        System.arraycopy(elems, 0, newElems, this.elements.length, elems.length);
        KUrl res = new KUrl(this.protocol, newElems);
        res.normalize();
        return res;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String[] getElements() {
        return this.elements;
    }

    public String getExtension() {
        String name = this.getName();
        int idx = name.lastIndexOf(".");
        if (idx >= 0) {
            return name.substring(idx + 1);
        }
        return "";
    }

    public String getFileNameNoExtension() {
        String name = this.getName();
        int idx = name.lastIndexOf(".");
        if (idx >= 0) {
            name = name.substring(0, idx);
        }
        return name;
    }

    public String toUrlString() {
        return this.toUrlString(true);
    }

    public String mangled() {
        return this.mangled(true);
    }

    public String mangled(boolean allowFileSep) {
        String s = this.toUrlString(false);
        StringBuilder res = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || !Character.isLetterOrDigit(c) && (c != '/' || !allowFileSep) && c != '.' && c != '-') {
                c = '_';
            }
            res.append(c);
        }
        while (res.length() > 180) {
            StringBuilder newB = new StringBuilder(res.length() / 2);
            for (int i = 0; i < res.length(); i += 2) {
                newB.append(res.charAt(i));
            }
            res = newB;
        }
        return res.toString();
    }

    public String toUrlString(boolean withProtocol) {
        String res = "";
        if (this.protocol != null && withProtocol) {
            res = res + this.protocol + "://";
        }
        for (int i = 0; i < this.elements.length; ++i) {
            String element = this.elements[i];
            res = res + element;
            if (i >= this.elements.length - 1) continue;
            res = res + "/";
        }
        return res;
    }

    public KUrl getParentURL() {
        return this.concat("../");
    }

    public String getName() {
        if (this.elements.length == 0) {
            return "";
        }
        return this.elements[this.elements.length - 1];
    }

    public boolean equals(Object obj) {
        if (obj instanceof KUrl) {
            KUrl other = (KUrl)obj;
            if (other.getElements().length != this.elements.length) {
                return false;
            }
            if (!Objects.equals(other.getProtocol(), this.protocol)) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                String element = this.elements[i];
                if (element.equals(other.getElements()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIgnoreProtocol(Object obj) {
        if (obj instanceof KUrl) {
            KUrl other = (KUrl)obj;
            if (other.getElements().length != this.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                String element = this.elements[i];
                if (element.equals(other.getElements()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hc = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            String element = this.elements[i];
            hc ^= element.hashCode();
        }
        if (this.protocol != null) {
            hc ^= this.protocol.hashCode();
        }
        return hc;
    }

    public String toString() {
        return this.toUrlString();
    }

    public boolean isRelative() {
        return this.protocol == null;
    }

    public KUrl prepend(String name) {
        return new KUrl(name).concat(this);
    }

    public boolean startsWith(KUrl base) {
        String baseProtocol;
        String protocol = this.getProtocol().toLowerCase();
        if ("https".equals(protocol)) {
            protocol = "http";
        }
        if ("https".equals(baseProtocol = base.getProtocol())) {
            baseProtocol = "http";
        }
        if (protocol == null) {
            protocol = baseProtocol;
        }
        if (base.getElements().length >= this.elements.length) {
            return false;
        }
        if (!protocol.equals(baseProtocol)) {
            return false;
        }
        for (int i = 0; i < base.getElements().length; ++i) {
            String b;
            String a;
            if (this.elements[i].equalsIgnoreCase(base.getElements()[i]) || i == 0 && (a = this.normalizeDomain(this.elements[i])).equals(b = this.normalizeDomain(base.getElements()[i]))) continue;
            return false;
        }
        return true;
    }

    public KUrl unified() {
        KUrl res = new KUrl(this.toUrlString(false));
        res.elements[0] = this.normalizeDomain(this.elements[0]);
        return res;
    }

    protected String normalizeDomain(String s) {
        int idx = s.lastIndexOf(".");
        if (idx >= 0) {
            s = s.substring(0, idx);
        }
        if (s.startsWith("www.")) {
            s = s.substring(4);
        }
        return s;
    }

    public String getDomain() {
        return this.elements[0];
    }
}

