/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.transpiler.jsx;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.webapp.npm.JNPMConfig;
import org.nustaq.kontraktor.webapp.transpiler.jsx.AttributeNode;
import org.nustaq.kontraktor.webapp.transpiler.jsx.ContentNode;
import org.nustaq.kontraktor.webapp.transpiler.jsx.GenOut;
import org.nustaq.kontraktor.webapp.transpiler.jsx.ImportSpec;
import org.nustaq.kontraktor.webapp.transpiler.jsx.Inp;
import org.nustaq.kontraktor.webapp.transpiler.jsx.JSBeautifier;
import org.nustaq.kontraktor.webapp.transpiler.jsx.JSNode;
import org.nustaq.kontraktor.webapp.transpiler.jsx.JSXParser;
import org.nustaq.kontraktor.webapp.transpiler.jsx.NodeLibNameResolver;
import org.nustaq.kontraktor.webapp.transpiler.jsx.TagNode;
import org.nustaq.kontraktor.webapp.transpiler.jsx.TokenNode;

public class JSXGenerator {
    String transformFunctionName;

    public JSXGenerator() {
        this("React.createElement");
    }

    public JSXGenerator(String transformFunctionName) {
        this.transformFunctionName = transformFunctionName;
    }

    public void generateJS(TokenNode root, PrintStream out) {
        for (int i = 0; i < root.getChildren().size(); ++i) {
            TokenNode tokenNode = root.getChildren().get(i);
            String s = tokenNode.getChars().toString().trim();
            if (s.startsWith("/*") && s.endsWith("*/")) {
                out.print("null");
                continue;
            }
            this.renderSingleNode(tokenNode, out);
        }
    }

    protected void renderSingleNode(TokenNode tokenNode, PrintStream out) {
        this.renderSingleNode(tokenNode, out, false);
    }

    protected void renderSingleNode(TokenNode tokenNode, PrintStream out, boolean quote) {
        if (tokenNode instanceof JSNode) {
            List<TokenNode> chs = tokenNode.getChildren();
            if (!(chs.size() <= 0 || JSXParser.SHIM_OBJ_SPREAD && chs.get(0) instanceof ContentNode && chs.get(0).getChars().length() > 0 && chs.get(0).getChars().charAt(0) == '_')) {
                if (chs.get(0) instanceof ContentNode) {
                    ((ContentNode)chs.get(0)).getChars().setCharAt(0, ' ');
                }
                if (chs.get(chs.size() - 1) instanceof ContentNode) {
                    StringBuilder chars = ((ContentNode)chs.get(chs.size() - 1)).getChars();
                    chars.setCharAt(chars.length() - 1, ' ');
                }
            }
            this.generateJS(tokenNode, out);
        } else if (tokenNode instanceof ContentNode) {
            if (quote) {
                out.print(this.quoteJSString(tokenNode.getChars()));
            } else {
                out.print(tokenNode.getChars());
            }
        } else if (tokenNode instanceof TagNode) {
            TagNode te = (TagNode)tokenNode;
            out.println(this.transformFunctionName + "(");
            if (te.isReactComponent()) {
                out.println("  " + te.getTagName() + ",");
            } else {
                out.println("  '" + te.getTagName() + "',");
            }
            if (te.getAttributes().size() == 0) {
                out.println("  null" + (te.getChildren().size() > 0 ? "," : ""));
            } else {
                boolean hasSpread = false;
                if (JSXParser.SHIM_OBJ_SPREAD) {
                    hasSpread = te.hasSprdInAttributes();
                }
                if (hasSpread) {
                    out.println("    _sprd({");
                } else {
                    out.println("    {");
                }
                int cnt = 0;
                for (int j = 0; j < te.getAttributes().size(); ++j) {
                    AttributeNode ae = te.getAttributes().get(j);
                    if (ae.getName().charAt(0) == '_' && "_JS_".equals(ae.getName().toString())) {
                        out.print("    '..." + cnt++ + "':");
                    } else {
                        out.print("    '" + ae.getName().toString() + "':");
                    }
                    if (ae.isJSValue()) {
                        this.generateJS(ae, out);
                    } else if (ae.getValue() != null) {
                        out.print(ae.getValue());
                    } else {
                        out.print("true");
                    }
                    if (j < te.getAttributes().size() - 1) {
                        out.println(",");
                        continue;
                    }
                    out.println("");
                }
                if (hasSpread) {
                    out.println("  })" + (te.getChildren().size() > 0 ? "," : ""));
                } else {
                    out.println("  }" + (te.getChildren().size() > 0 ? "," : ""));
                }
            }
            boolean nonEmptyWasThere = false;
            for (int j = 0; j < te.getChildren().size(); ++j) {
                TokenNode entry = te.getChildren().get(j);
                if (entry instanceof ContentNode) {
                    ContentNode ce = (ContentNode)entry;
                    ce.trim();
                    if (ce.isEmpty()) continue;
                    if (nonEmptyWasThere) {
                        out.println(",");
                    }
                    nonEmptyWasThere = true;
                    out.print("'");
                    this.renderSingleNode(entry, out, true);
                    out.print("'");
                    continue;
                }
                if (nonEmptyWasThere) {
                    out.println(",");
                }
                nonEmptyWasThere = true;
                this.renderSingleNode(entry, out);
            }
            out.print(")");
        } else {
            System.out.println("UNKNOWN NODE " + tokenNode);
        }
    }

    private String quoteJSString(StringBuilder value) {
        String s = value.toString();
        s = s.replace("\"", "\\\"");
        s = s.replace("'", "\\'");
        return s;
    }

    public static String camelCase(String name) {
        int i = name.indexOf("-");
        if (i > 0) {
            return JSXGenerator.camelCase(name.substring(0, i) + Character.toUpperCase(name.charAt(i + 1)) + name.substring(i + 2));
        }
        return name;
    }

    public static ParseResult process(File f, boolean pretty, NodeLibNameResolver nlib, JNPMConfig config) throws IOException {
        JSXParser jsx = new JSXParser(f, nlib);
        JSNode root = new JSNode();
        byte[] bytes = Files.readAllBytes(f.toPath());
        String cont = new String(bytes, "UTF-8");
        jsx.parseJS(root, new Inp(cont));
        if (jsx.depth != 0) {
            Log.Warn(JSXGenerator.class, (String)("probably parse issues non-matching braces in " + f.getAbsolutePath()));
            ParseResult parseResult = new ParseResult(f, bytes, f.getName().endsWith(".js") ? "js" : "jsx", jsx.getImports(), jsx.getTopLevelObjects(), jsx.getIgnoredRequires(), jsx.getDefaultExport());
            return parseResult.patchImports(config.getNodeLibraryMap());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(bytes.length);
        PrintStream ps = new PrintStream(out);
        JSXGenerator gen = new JSXGenerator(config.getTransformFunction());
        gen.generateJS(root, ps);
        ps.flush();
        ps.close();
        byte[] filedata = out.toByteArray();
        if (pretty) {
            ByteArrayOutputStream outpretty = new ByteArrayOutputStream(filedata.length + filedata.length / 5);
            PrintStream pspretty = new PrintStream(outpretty);
            JSBeautifier beautifier = new JSBeautifier();
            beautifier.parseJS(new GenOut(pspretty), new Inp(new String(filedata, "UTF-8")));
            pspretty.flush();
            pspretty.close();
            filedata = outpretty.toByteArray();
        }
        ParseResult parseResult = new ParseResult(f, filedata, f.getName().endsWith(".js") ? "js" : "jsx", jsx.getImports(), jsx.getTopLevelObjects(), jsx.getIgnoredRequires(), jsx.getDefaultExport());
        parseResult.patchImports(config.getNodeLibraryMap());
        return parseResult;
    }

    public static class ParseResult {
        File f;
        byte[] filedata;
        List<ImportSpec> imports;
        List<String> globals;
        Set<String> ignoredRequires;
        String extension;
        String defaultExport;

        public ParseResult(File f, byte[] filedata, String extension, List<ImportSpec> imports, List<String> globals, Set<String> ignoredReq, String defaultExport) {
            this.filedata = filedata;
            this.imports = imports;
            this.globals = globals;
            this.extension = extension;
            this.f = f;
            this.ignoredRequires = ignoredReq;
            this.defaultExport = defaultExport;
        }

        public String getDefaultExport() {
            return this.defaultExport;
        }

        public Set<String> getIgnoredRequires() {
            return this.ignoredRequires;
        }

        public String getExtension() {
            return this.extension;
        }

        public byte[] getFiledata() {
            return this.filedata;
        }

        public List<ImportSpec> getImports() {
            return this.imports;
        }

        public List<String> getGlobals() {
            return this.globals;
        }

        public boolean generateESWrap() {
            return !this.generateCommonJSWrap() && ("jsx".equals(this.extension) || this.imports.size() > 0);
        }

        public boolean generateCommonJSWrap() {
            return this.f.getAbsolutePath().replace('\\', '/').indexOf("/node_modules/") >= 0;
        }

        public String getFilePath() {
            return this.f.getAbsolutePath();
        }

        public String getDir() {
            return this.f.getParentFile().getAbsolutePath();
        }

        public File getFile() {
            return this.f;
        }

        public ParseResult patchImports(Map<String, String> nodeLibraryMap) {
            if (nodeLibraryMap != null && nodeLibraryMap.size() > 0) {
                this.imports.forEach(imp -> {
                    String s = (String)nodeLibraryMap.get(imp.getFrom());
                    if (s != null) {
                        imp.from(s);
                    }
                });
            }
            return this;
        }
    }
}

