/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.transpiler.jsx;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.webapp.transpiler.jsx.AttributeNode;
import org.nustaq.kontraktor.webapp.transpiler.jsx.ImportSpec;
import org.nustaq.kontraktor.webapp.transpiler.jsx.Inp;
import org.nustaq.kontraktor.webapp.transpiler.jsx.JSNode;
import org.nustaq.kontraktor.webapp.transpiler.jsx.NodeLibNameResolver;
import org.nustaq.kontraktor.webapp.transpiler.jsx.ParseUtils;
import org.nustaq.kontraktor.webapp.transpiler.jsx.TagNode;
import org.nustaq.kontraktor.webapp.transpiler.jsx.TokenNode;

public class JSXParser
implements ParseUtils {
    public static boolean SHIM_OBJ_SPREAD = true;
    List<ImportSpec> imports = new ArrayList<ImportSpec>();
    List<String> topLevelObjects = new ArrayList<String>();
    HashSet<String> ignoredRequires = new HashSet();
    protected File file;
    protected NodeLibNameResolver libNameResolver;
    protected String defaultExport;
    int depth = 0;
    boolean exportDefault = false;
    Boolean isNodeModule;
    static Object[] entities = new Object[]{"quot", Character.valueOf('\"'), "amp", Character.valueOf('&'), "apos", Character.valueOf('\''), "lt", Character.valueOf('<'), "gt", Character.valueOf('>'), "nbsp", Character.valueOf('\u00a0'), "iexcl", Character.valueOf('\u00a1'), "cent", Character.valueOf('\u00a2'), "pound", Character.valueOf('\u00a3'), "curren", Character.valueOf('\u00a4'), "yen", Character.valueOf('\u00a5'), "brvbar", Character.valueOf('\u00a6'), "sect", Character.valueOf('\u00a7'), "uml", Character.valueOf('\u00a8'), "copy", Character.valueOf('\u00a9'), "ordf", Character.valueOf('\u00aa'), "laquo", Character.valueOf('\u00ab'), "not", Character.valueOf('\u00ac'), "shy", Character.valueOf('\u00ad'), "reg", Character.valueOf('\u00ae'), "macr", Character.valueOf('\u00af'), "deg", Character.valueOf('\u00b0'), "plusmn", Character.valueOf('\u00b1'), "sup2", Character.valueOf('\u00b2'), "sup3", Character.valueOf('\u00b3'), "acute", Character.valueOf('\u00b4'), "micro", Character.valueOf('\u00b5'), "para", Character.valueOf('\u00b6'), "middot", Character.valueOf('\u00b7'), "cedil", Character.valueOf('\u00b8'), "sup1", Character.valueOf('\u00b9'), "ordm", Character.valueOf('\u00ba'), "raquo", Character.valueOf('\u00bb'), "frac14", Character.valueOf('\u00bc'), "frac12", Character.valueOf('\u00bd'), "frac34", Character.valueOf('\u00be'), "iquest", Character.valueOf('\u00bf'), "Agrave", Character.valueOf('\u00c0'), "Aacute", Character.valueOf('\u00c1'), "Acirc", Character.valueOf('\u00c2'), "Atilde", Character.valueOf('\u00c3'), "Auml", Character.valueOf('\u00c4'), "Aring", Character.valueOf('\u00c5'), "AElig", Character.valueOf('\u00c6'), "Ccedil", Character.valueOf('\u00c7'), "Egrave", Character.valueOf('\u00c8'), "Eacute", Character.valueOf('\u00c9'), "Ecirc", Character.valueOf('\u00ca'), "Euml", Character.valueOf('\u00cb'), "Igrave", Character.valueOf('\u00cc'), "Iacute", Character.valueOf('\u00cd'), "Icirc", Character.valueOf('\u00ce'), "Iuml", Character.valueOf('\u00cf'), "ETH", Character.valueOf('\u00d0'), "Ntilde", Character.valueOf('\u00d1'), "Ograve", Character.valueOf('\u00d2'), "Oacute", Character.valueOf('\u00d3'), "Ocirc", Character.valueOf('\u00d4'), "Otilde", Character.valueOf('\u00d5'), "Ouml", Character.valueOf('\u00d6'), "times", Character.valueOf('\u00d7'), "Oslash", Character.valueOf('\u00d8'), "Ugrave", Character.valueOf('\u00d9'), "Uacute", Character.valueOf('\u00da'), "Ucirc", Character.valueOf('\u00db'), "Uuml", Character.valueOf('\u00dc'), "Yacute", Character.valueOf('\u00dd'), "THORN", Character.valueOf('\u00de'), "szlig", Character.valueOf('\u00df'), "agrave", Character.valueOf('\u00e0'), "aacute", Character.valueOf('\u00e1'), "acirc", Character.valueOf('\u00e2'), "atilde", Character.valueOf('\u00e3'), "auml", Character.valueOf('\u00e4'), "aring", Character.valueOf('\u00e5'), "aelig", Character.valueOf('\u00e6'), "ccedil", Character.valueOf('\u00e7'), "egrave", Character.valueOf('\u00e8'), "eacute", Character.valueOf('\u00e9'), "ecirc", Character.valueOf('\u00ea'), "euml", Character.valueOf('\u00eb'), "igrave", Character.valueOf('\u00ec'), "iacute", Character.valueOf('\u00ed'), "icirc", Character.valueOf('\u00ee'), "iuml", Character.valueOf('\u00ef'), "eth", Character.valueOf('\u00f0'), "ntilde", Character.valueOf('\u00f1'), "ograve", Character.valueOf('\u00f2'), "oacute", Character.valueOf('\u00f3'), "ocirc", Character.valueOf('\u00f4'), "otilde", Character.valueOf('\u00f5'), "ouml", Character.valueOf('\u00f6'), "divide", Character.valueOf('\u00f7'), "oslash", Character.valueOf('\u00f8'), "ugrave", Character.valueOf('\u00f9'), "uacute", Character.valueOf('\u00fa'), "ucirc", Character.valueOf('\u00fb'), "uuml", Character.valueOf('\u00fc'), "yacute", Character.valueOf('\u00fd'), "thorn", Character.valueOf('\u00fe'), "yuml", Character.valueOf('\u00ff'), "OElig", Character.valueOf('\u0152'), "oelig", Character.valueOf('\u0153'), "Scaron", Character.valueOf('\u0160'), "scaron", Character.valueOf('\u0161'), "Yuml", Character.valueOf('\u0178'), "fnof", Character.valueOf('\u0192'), "circ", Character.valueOf('\u02c6'), "tilde", Character.valueOf('\u02dc'), "Alpha", Character.valueOf('\u0391'), "Beta", Character.valueOf('\u0392'), "Gamma", Character.valueOf('\u0393'), "Delta", Character.valueOf('\u0394'), "Epsilon", Character.valueOf('\u0395'), "Zeta", Character.valueOf('\u0396'), "Eta", Character.valueOf('\u0397'), "Theta", Character.valueOf('\u0398'), "Iota", Character.valueOf('\u0399'), "Kappa", Character.valueOf('\u039a'), "Lambda", Character.valueOf('\u039b'), "Mu", Character.valueOf('\u039c'), "Nu", Character.valueOf('\u039d'), "Xi", Character.valueOf('\u039e'), "Omicron", Character.valueOf('\u039f'), "Pi", Character.valueOf('\u03a0'), "Rho", Character.valueOf('\u03a1'), "Sigma", Character.valueOf('\u03a3'), "Tau", Character.valueOf('\u03a4'), "Upsilon", Character.valueOf('\u03a5'), "Phi", Character.valueOf('\u03a6'), "Chi", Character.valueOf('\u03a7'), "Psi", Character.valueOf('\u03a8'), "Omega", Character.valueOf('\u03a9'), "alpha", Character.valueOf('\u03b1'), "beta", Character.valueOf('\u03b2'), "gamma", Character.valueOf('\u03b3'), "delta", Character.valueOf('\u03b4'), "epsilon", Character.valueOf('\u03b5'), "zeta", Character.valueOf('\u03b6'), "eta", Character.valueOf('\u03b7'), "theta", Character.valueOf('\u03b8'), "iota", Character.valueOf('\u03b9'), "kappa", Character.valueOf('\u03ba'), "lambda", Character.valueOf('\u03bb'), "mu", Character.valueOf('\u03bc'), "nu", Character.valueOf('\u03bd'), "xi", Character.valueOf('\u03be'), "omicron", Character.valueOf('\u03bf'), "pi", Character.valueOf('\u03c0'), "rho", Character.valueOf('\u03c1'), "sigmaf", Character.valueOf('\u03c2'), "sigma", Character.valueOf('\u03c3'), "tau", Character.valueOf('\u03c4'), "upsilon", Character.valueOf('\u03c5'), "phi", Character.valueOf('\u03c6'), "chi", Character.valueOf('\u03c7'), "psi", Character.valueOf('\u03c8'), "omega", Character.valueOf('\u03c9'), "thetasym", Character.valueOf('\u03d1'), "upsih", Character.valueOf('\u03d2'), "piv", Character.valueOf('\u03d6'), "ensp", Character.valueOf('\u2002'), "emsp", Character.valueOf('\u2003'), "thinsp", Character.valueOf('\u2009'), "zwnj", Character.valueOf('\u200c'), "zwj", Character.valueOf('\u200d'), "lrm", Character.valueOf('\u200e'), "rlm", Character.valueOf('\u200f'), "ndash", Character.valueOf('\u2013'), "mdash", Character.valueOf('\u2014'), "lsquo", Character.valueOf('\u2018'), "rsquo", Character.valueOf('\u2019'), "sbquo", Character.valueOf('\u201a'), "ldquo", Character.valueOf('\u201c'), "rdquo", Character.valueOf('\u201d'), "bdquo", Character.valueOf('\u201e'), "dagger", Character.valueOf('\u2020'), "Dagger", Character.valueOf('\u2021'), "bull", Character.valueOf('\u2022'), "hellip", Character.valueOf('\u2026'), "permil", Character.valueOf('\u2030'), "prime", Character.valueOf('\u2032'), "Prime", Character.valueOf('\u2033'), "lsaquo", Character.valueOf('\u2039'), "rsaquo", Character.valueOf('\u203a'), "oline", Character.valueOf('\u203e'), "frasl", Character.valueOf('\u2044'), "euro", Character.valueOf('\u20ac'), "image", Character.valueOf('\u2111'), "weierp", Character.valueOf('\u2118'), "real", Character.valueOf('\u211c'), "trade", Character.valueOf('\u2122'), "alefsym", Character.valueOf('\u2135'), "larr", Character.valueOf('\u2190'), "uarr", Character.valueOf('\u2191'), "rarr", Character.valueOf('\u2192'), "darr", Character.valueOf('\u2193'), "harr", Character.valueOf('\u2194'), "crarr", Character.valueOf('\u21b5'), "lArr", Character.valueOf('\u21d0'), "uArr", Character.valueOf('\u21d1'), "rArr", Character.valueOf('\u21d2'), "dArr", Character.valueOf('\u21d3'), "hArr", Character.valueOf('\u21d4'), "forall", Character.valueOf('\u2200'), "part", Character.valueOf('\u2202'), "exist", Character.valueOf('\u2203'), "empty", Character.valueOf('\u2205'), "nabla", Character.valueOf('\u2207'), "isin", Character.valueOf('\u2208'), "notin", Character.valueOf('\u2209'), "ni", Character.valueOf('\u220b'), "prod", Character.valueOf('\u220f'), "sum", Character.valueOf('\u2211'), "minus", Character.valueOf('\u2212'), "lowast", Character.valueOf('\u2217'), "radic", Character.valueOf('\u221a'), "prop", Character.valueOf('\u221d'), "infin", Character.valueOf('\u221e'), "ang", Character.valueOf('\u2220'), "and", Character.valueOf('\u2227'), "or", Character.valueOf('\u2228'), "cap", Character.valueOf('\u2229'), "cup", Character.valueOf('\u222a'), "'int'", Character.valueOf('\u222b'), "there4", Character.valueOf('\u2234'), "sim", Character.valueOf('\u223c'), "cong", Character.valueOf('\u2245'), "asymp", Character.valueOf('\u2248'), "ne", Character.valueOf('\u2260'), "equiv", Character.valueOf('\u2261'), "le", Character.valueOf('\u2264'), "ge", Character.valueOf('\u2265'), "sub", Character.valueOf('\u2282'), "sup", Character.valueOf('\u2283'), "nsub", Character.valueOf('\u2284'), "sube", Character.valueOf('\u2286'), "supe", Character.valueOf('\u2287'), "oplus", Character.valueOf('\u2295'), "otimes", Character.valueOf('\u2297'), "perp", Character.valueOf('\u22a5'), "sdot", Character.valueOf('\u22c5'), "lceil", Character.valueOf('\u2308'), "rceil", Character.valueOf('\u2309'), "lfloor", Character.valueOf('\u230a'), "rfloor", Character.valueOf('\u230b'), "lang", Character.valueOf('\u2329'), "rang", Character.valueOf('\u232a'), "loz", Character.valueOf('\u25ca'), "spades", Character.valueOf('\u2660'), "clubs", Character.valueOf('\u2663'), "hearts", Character.valueOf('\u2665'), "diams", Character.valueOf('\u2666')};
    public static Map<String, Character> entityMap = new HashMap<String, Character>();

    public JSXParser(File f, NodeLibNameResolver libNameResolver) {
        this.file = f;
        this.libNameResolver = libNameResolver;
    }

    public String getDefaultExport() {
        return this.defaultExport;
    }

    public List<String> getTopLevelObjects() {
        return this.topLevelObjects;
    }

    public void parseJS(TokenNode cur, Inp in) {
        int braceCount = 0;
        boolean trackNextIdentifier = false;
        StringBuilder global = new StringBuilder();
        boolean returnOnLastMatchingBrace = in.ch() == '{';
        int[] lastBracePos = new int[200];
        int[] lastBracePosCur = new int[200];
        String[] braceInsert = new String[200];
        int rcnt = 0;
        char ch = in.ch();
        while ((ch = in.ch()) > '\u0000') {
            if (ch == 'e' || ch == '/' || ch == 'r') {
                if (in.match("export") && this.isCommandContext(in, "export")) {
                    in.advance("export".length());
                    in.skipWS();
                    if (!in.match("default")) continue;
                    in.advance("default".length());
                    in.skipWS();
                    this.exportDefault = true;
                    continue;
                }
                if (in.match("//@ignore:")) {
                    in.advance("//@ignore:".length());
                    StringBuilder ig = new StringBuilder();
                    while (!Character.isWhitespace(in.ch())) {
                        ig.append(in.ch());
                        in.inc();
                    }
                    this.ignoredRequires.add(ig.toString());
                    continue;
                }
                if (in.match("require") && this.isFunContext(in, "require") && this.isNodeModule()) {
                    ImportSpec spec = this.parseRequire(in);
                    if (spec != null) {
                        if (this.libNameResolver != null) {
                            String finalLibName = this.libNameResolver.getFinalLibName(this.file, this.libNameResolver, spec.from);
                            cur.add("require('" + finalLibName + "')");
                            continue;
                        }
                        cur.add("require('" + spec.from + "')");
                        continue;
                    }
                    cur.add("/*could not parse name*/");
                    ch = in.ch();
                }
            }
            if (ch == 'i' && in.match("import") && this.isCommandContext(in, "import")) {
                this.parseImport(in);
                continue;
            }
            if (ch == '<' && this.isTagLeft(in) && Character.isLetter(in.ch(1))) {
                cur.closeCont();
                TagNode tokenEntry = new TagNode();
                cur.addChild(tokenEntry);
                ++this.depth;
                this.parseJSX(tokenEntry, in);
                --this.depth;
                continue;
            }
            if (ch == '/' && in.ch(1) == '/') {
                cur.add(this.readSlashComment(in));
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                cur.add(this.readJSString(in));
                continue;
            }
            if (ch == '/' && in.ch(1) == '*') {
                cur.add(this.readStarComment(in));
                continue;
            }
            if (ch == '/' && "(,=:[!&|?{};".indexOf(in.scanLastNWS()) >= 0) {
                cur.add(this.readRegexp(in));
                continue;
            }
            if (SHIM_OBJ_SPREAD && ch == '.' && in.match("...") && in.at(lastBracePos[this.depth]) == '{') {
                if (braceInsert[this.depth] == null) {
                    cur.chars.insert(lastBracePosCur[this.depth], "_sprd(");
                    braceInsert[this.depth] = ")";
                }
                cur.add("'..." + rcnt++ + "':");
                in.advance(3);
                continue;
            }
            if (ch == '{' || ch == '[' || ch == '(') {
                ++this.depth;
                if (this.depth >= 0) {
                    lastBracePos[this.depth] = in.index();
                    lastBracePosCur[this.depth] = cur.chars.length();
                }
            } else if (ch == '}' || ch == ']' || ch == ')') {
                --this.depth;
            }
            if (returnOnLastMatchingBrace) {
                if (ch == '{') {
                    ++braceCount;
                }
                if (ch == '}') {
                    if (--braceCount < 0) {
                        System.out.println("Warning: brace mismatch " + in);
                    }
                    if (braceCount <= 0) {
                        cur.add(ch);
                        in.advance(1);
                        cur.closeCont();
                        return;
                    }
                }
            }
            if (!(this.depth != 0 || Character.isLetterOrDigit(in.ch(-1)) || ch != 'v' && ch != 'l' && ch != 'f' && ch != 'c')) {
                if (in.match("var ") || in.match("let ")) {
                    for (int i = 0; i < 4; ++i) {
                        cur.add(in.ch());
                        in.inc();
                    }
                    trackNextIdentifier = true;
                    continue;
                }
                if (in.match("function ")) {
                    int length = "function ".length();
                    for (int i = 0; i < length; ++i) {
                        cur.add(in.ch());
                        in.inc();
                    }
                    trackNextIdentifier = true;
                    continue;
                }
                if (in.match("const ") || in.match("class ")) {
                    for (int i = 0; i < 5; ++i) {
                        cur.add(in.ch());
                        in.inc();
                    }
                    trackNextIdentifier = true;
                    continue;
                }
            }
            if (trackNextIdentifier) {
                if (Character.isJavaIdentifierPart(ch)) {
                    global.append(ch);
                } else if (global.length() > 0) {
                    String ex = global.toString();
                    this.topLevelObjects.add(ex);
                    this.defaultExport = ex;
                    global.setLength(0);
                    trackNextIdentifier = false;
                    this.exportDefault = false;
                }
            }
            cur.add(ch);
            if (ch == '}') {
                if (this.depth + 1 >= 0) {
                    if (braceInsert[this.depth + 1] != null) {
                        cur.chars.append(braceInsert[this.depth + 1]);
                        braceInsert[this.depth + 1] = null;
                    }
                } else {
                    Log.Warn((Object)this, (String)("imbalanced braces. " + this.file.getAbsolutePath()));
                }
            }
            ++in.index;
        }
    }

    private boolean isNodeModule() {
        if (this.isNodeModule == null) {
            this.isNodeModule = this.file.getAbsolutePath().replace('\\', '/').contains("/node_modules/");
        }
        return this.isNodeModule;
    }

    private boolean isCommandContext(Inp in, String command) {
        return this.isCCChar(in.ch(-1)) && this.isCCChar(in.ch(command.length()));
    }

    private boolean isFunContext(Inp in, String command) {
        return this.isCCChar(in.ch(-1)) && this.nextNonWS(in, command.length()) == '(';
    }

    private char nextNonWS(Inp in, int off) {
        boolean c = false;
        int i = off;
        while (in.ch(i) <= ' ') {
            ++i;
        }
        return in.ch(i);
    }

    private boolean isCCChar(char ch) {
        boolean b = !Character.isJavaIdentifierPart(ch) || ch <= ' ';
        return b;
    }

    private boolean isTagLeft(Inp in) {
        int pos = in.index;
        in.advance(-1);
        while (in.ch() <= ' ' && in.index >= 0) {
            in.advance(-1);
        }
        int ch = in.ch();
        if (ch == 0) {
            ch = 59;
        }
        if (ch == 110) {
            boolean res = in.matchReverse("return");
            in.index = pos;
            return res;
        }
        in.index = pos;
        return "/>;:{([,}?=&|".indexOf(ch) >= 0;
    }

    private ImportSpec parseRequire(Inp in) {
        int i = in.index();
        in.advance("require".length());
        in.skipWS();
        if (in.ch() != '(') {
            Log.Warn((Object)this, (String)("fake require:" + in + " " + this.file.getAbsolutePath()));
            in.index = i;
            return null;
        }
        in.advance(1);
        in.skipWS();
        StringBuilder reqString = this.readJSString(in);
        in.skipWS();
        if (in.ch() != ')') {
            Log.Warn((Object)this, (String)("unparseable require:" + in + " " + this.file.getAbsolutePath()));
            in.index = i;
            return null;
        }
        ImportSpec spec = new ImportSpec().requiredin(this.file);
        spec.from = reqString.substring(1, reqString.length() - 1);
        spec.isRequire = true;
        this.imports.add(spec);
        in.inc();
        return spec;
    }

    void parseImport(Inp in) {
        in.advance("import ".length());
        ImportSpec spec = new ImportSpec().requiredin(this.file);
        while (in.ch() > '\u0000') {
            StringBuilder sb;
            in.skipWS();
            if (in.ch() == '{') {
                in.inc();
                sb = new StringBuilder();
                while (in.ch() != '}') {
                    sb.append(in.ch());
                    in.inc();
                }
                in.inc();
                String[] split = sb.toString().split(",");
                for (int i = 0; i < split.length; ++i) {
                    String s = split[i].trim();
                    if (s.indexOf(" as ") > 0) {
                        String[] as = s.split(" as ");
                        if (as.length != 2) {
                            throw new RuntimeException("expected: 'X as Y':" + in + " " + this.file.getAbsolutePath());
                        }
                        spec.getComponents().add(as[0]);
                        spec.getAliases().add(as[1]);
                        continue;
                    }
                    if (s.length() <= 0) continue;
                    spec.getComponents().add(s);
                    spec.getAliases().add(s);
                }
            } else {
                sb = new StringBuilder();
                while (this.isAttrNamePart(in.ch())) {
                    sb.append(in.ch());
                    in.inc();
                }
                in.skipWS();
                if (in.match("as ")) {
                    in.advance(2);
                    in.skipWS();
                    spec.component(sb.toString());
                    StringBuilder al = new StringBuilder();
                    while (!Character.isWhitespace(in.ch())) {
                        al.append(in.ch());
                        in.inc();
                    }
                    spec.alias(al.toString());
                } else {
                    spec.component(sb.toString());
                    spec.alias = sb.toString();
                }
            }
            in.skipWS();
            if (in.ch() != ',') break;
            in.inc();
            in.skipWS();
        }
        in.skipWS();
        if (!in.match("from")) {
            throw new RuntimeException("expected from >" + in + "<");
        }
        in.advance(4);
        in.skipWS();
        StringBuilder src = this.readJSString(in);
        src.delete(0, 1);
        src.setLength(src.length() - 1);
        spec.from(src.toString());
        while (in.ch() >= ' ') {
            in.inc();
        }
        while (in.ch() < ' ') {
            in.inc();
        }
        this.imports.add(spec);
    }

    public List<ImportSpec> getImports() {
        return this.imports;
    }

    void parseJSX(TagNode tokenEntry, Inp in) {
        StringBuilder tag;
        tokenEntry.tagName = tag = this.parseTagName(in);
        boolean autoclosed = this.parseAttributesOrTEnd(tokenEntry, in);
        if (!autoclosed) {
            this.parseJSXContent(tokenEntry, in);
        }
    }

    void parseJSXContent(TagNode tag, Inp in) {
        while (in.ch() > '\u0000') {
            if (in.ch() == '<' && in.ch(1) == '/') {
                in.advance(2);
                while (in.ch() != '>' && in.ch() > '\u0000') {
                    in.inc();
                }
                in.inc();
                tag.closeCont();
                return;
            }
            if (in.ch() == '<' && Character.isLetter(in.ch(1))) {
                tag.closeCont();
                TagNode te = new TagNode();
                this.parseJSX(te, in);
                tag.addChild(te);
                continue;
            }
            if (in.ch() == '&') {
                int off;
                StringBuilder ent = new StringBuilder();
                for (off = 1; off < 20 && in.ch(off) != ';'; ++off) {
                    ent.append(in.ch(off));
                }
                if (in.ch(off) != ';') continue;
                Character character = entityMap.get(ent.toString());
                if (character == null && in.ch(1) == '#') {
                    try {
                        character = in.ch(2) == 'x' ? Character.valueOf((char)Integer.parseInt(ent.toString().substring(2), 16)) : Character.valueOf((char)Integer.parseInt(ent.toString().substring(2)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (character == null) continue;
                tag.add(character.charValue());
                in.advance(off + 1);
                continue;
            }
            if (in.ch() == '{') {
                tag.closeCont();
                JSNode js = new JSNode();
                tag.addChild(js);
                this.parseJS(js, in);
                continue;
            }
            tag.add(in.ch());
            in.inc();
        }
    }

    boolean parseAttributesOrTEnd(TagNode tokenEntry, Inp in) {
        while (in.ch(0) > '\u0000') {
            in.skipWS();
            if (in.ch() == '/' && in.ch(1) == '>') {
                in.advance(2);
                return true;
            }
            if (in.ch() == '>') {
                in.inc();
                return false;
            }
            StringBuilder name = this.readAttrName(in);
            in.skipWS();
            AttributeNode attr = new AttributeNode().name(name);
            tokenEntry.addAttribute(attr);
            if (in.ch() == '/' && in.ch(1) == '>') {
                in.advance(2);
                return true;
            }
            in.skipWS();
            if (in.ch() == '=') {
                in.inc();
                this.readAttrValue(attr, in);
            }
            if (tokenEntry.attributes.size() <= 100) continue;
            throw new RuntimeException("parsing error:" + in);
        }
        return false;
    }

    private void readAttrValue(AttributeNode attr, Inp in) {
        switch (in.ch()) {
            case '\"': 
            case '\'': {
                attr.value(this.readJSString(in));
                break;
            }
            case '{': {
                JSNode cur = new JSNode();
                attr.addChild(cur);
                this.parseJS(cur, in);
                break;
            }
            default: {
                throw new RuntimeException("expect attribute value:" + in);
            }
        }
    }

    public HashSet<String> getIgnoredRequires() {
        return this.ignoredRequires;
    }

    private StringBuilder readAttrName(Inp in) {
        StringBuilder res = new StringBuilder(10);
        while (this.isAttrNamePart(in.ch())) {
            res.append(in.ch(0));
            in.advance(1);
        }
        return res;
    }

    boolean isAttrNamePart(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '-';
    }

    StringBuilder parseTagName(Inp in) {
        in.advance(1);
        StringBuilder res = new StringBuilder(10);
        while (this.isTagNamePart(in.ch(0))) {
            res.append(in.ch(0));
            in.advance(1);
        }
        return res;
    }

    private boolean isTagNamePart(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '-' || ch == '.' || ch == ':';
    }

    static {
        for (int i = 0; i < entities.length; i += 2) {
            Object entity = entities[i];
            entityMap.put((String)entity, (Character)entities[i + 1]);
        }
    }
}

