/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.transpiler.jsx;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.List;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.webapp.transpiler.jsx.GenOut;
import org.nustaq.kontraktor.webapp.transpiler.jsx.Inp;
import org.nustaq.kontraktor.webapp.transpiler.jsx.JSBeautifier;
import org.nustaq.kontraktor.webapp.transpiler.jsx.JSXParser;

public class JSXGenerator {
    public void generateJS(JSXParser.TokenEntry root, PrintStream out) {
        for (int i = 0; i < root.getChildren().size(); ++i) {
            JSXParser.TokenEntry tokenEntry = root.getChildren().get(i);
            this.renderSingleNode(tokenEntry, out);
        }
    }

    protected void renderSingleNode(JSXParser.TokenEntry tokenEntry, PrintStream out) {
        this.renderSingleNode(tokenEntry, out, false);
    }

    protected void renderSingleNode(JSXParser.TokenEntry tokenEntry, PrintStream out, boolean quote) {
        if (tokenEntry instanceof JSXParser.JSEntry) {
            List<JSXParser.TokenEntry> chs = tokenEntry.getChildren();
            if (chs.size() > 0) {
                if (chs.get(0) instanceof JSXParser.ContentEntry) {
                    ((JSXParser.ContentEntry)chs.get(0)).getChars().setCharAt(0, ' ');
                }
                if (chs.get(chs.size() - 1) instanceof JSXParser.ContentEntry) {
                    StringBuilder chars = ((JSXParser.ContentEntry)chs.get(chs.size() - 1)).getChars();
                    chars.setCharAt(chars.length() - 1, ' ');
                }
            }
            this.generateJS(tokenEntry, out);
        } else if (tokenEntry instanceof JSXParser.ContentEntry) {
            if (quote) {
                out.print(this.quoteJSString(tokenEntry.getChars()));
            } else {
                out.print(tokenEntry.getChars());
            }
        } else if (tokenEntry instanceof JSXParser.TagEntry) {
            JSXParser.TagEntry te = (JSXParser.TagEntry)tokenEntry;
            out.println("React.createElement(");
            if (te.isReactComponent()) {
                out.println("  " + te.getTagName() + ",");
            } else {
                out.println("  '" + te.getTagName() + "',");
            }
            if (te.getAttributes().size() == 0) {
                out.println("  null" + (te.getChildren().size() > 0 ? "," : ""));
            } else {
                out.println("  {");
                for (int j = 0; j < te.getAttributes().size(); ++j) {
                    JSXParser.AttributeEntry ae = te.getAttributes().get(j);
                    out.print("    '" + ae.getName().toString() + "':");
                    if (ae.isJSValue()) {
                        this.generateJS(ae, out);
                    } else if (ae.getValue() != null) {
                        out.print(ae.getValue());
                    } else {
                        out.print("true");
                    }
                    if (j < te.getAttributes().size() - 1) {
                        out.println(",");
                        continue;
                    }
                    out.println("");
                }
                out.println("  }" + (te.getChildren().size() > 0 ? "," : ""));
            }
            boolean nonEmptyWasThere = false;
            for (int j = 0; j < te.getChildren().size(); ++j) {
                JSXParser.TokenEntry entry = te.getChildren().get(j);
                if (entry instanceof JSXParser.ContentEntry) {
                    JSXParser.ContentEntry ce = (JSXParser.ContentEntry)entry;
                    ce.trim();
                    if (ce.isEmpty()) continue;
                    if (nonEmptyWasThere) {
                        out.println(",");
                    }
                    nonEmptyWasThere = true;
                    out.print("'");
                    this.renderSingleNode(entry, out, true);
                    out.print("'");
                    continue;
                }
                if (nonEmptyWasThere) {
                    out.println(",");
                }
                nonEmptyWasThere = true;
                this.renderSingleNode(entry, out);
            }
            out.print(")");
        } else {
            System.out.println("UNKNOWN NODE " + tokenEntry);
        }
    }

    private String quoteJSString(StringBuilder value) {
        String s = value.toString();
        s = s.replace("\"", "\\\"");
        s = s.replace("'", "\\'");
        return s;
    }

    public static String camelCase(String name) {
        int i = name.indexOf("-");
        if (i > 0) {
            return JSXGenerator.camelCase(name.substring(0, i) + Character.toUpperCase(name.charAt(i + 1)) + name.substring(i + 2));
        }
        return name;
    }

    public static ParseResult process(File f, boolean pretty) throws IOException {
        JSXParser jsx = new JSXParser();
        JSXParser.JSEntry root = new JSXParser.JSEntry();
        byte[] bytes = Files.readAllBytes(f.toPath());
        jsx.parseJS(root, new Inp(new String(bytes, "UTF-8")));
        if (jsx.depth != 0) {
            Log.Warn(JSXGenerator.class, (String)("probably parse issues non-matching braces in " + f.getAbsolutePath()));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        PrintStream ps = new PrintStream(out);
        JSXGenerator gen = new JSXGenerator();
        gen.generateJS(root, ps);
        ps.flush();
        ps.close();
        byte[] filedata = out.toByteArray();
        if (pretty) {
            ByteArrayOutputStream outpretty = new ByteArrayOutputStream(filedata.length + filedata.length / 5);
            PrintStream pspretty = new PrintStream(outpretty);
            JSBeautifier beautifier = new JSBeautifier();
            beautifier.parseJS(new GenOut(pspretty), new Inp(new String(filedata, "UTF-8")));
            pspretty.flush();
            pspretty.close();
            filedata = outpretty.toByteArray();
        }
        return new ParseResult(filedata, jsx.getImports(), jsx.getTopLevelObjects());
    }

    public static class ParseResult {
        byte[] filedata;
        List<JSXParser.ImportSpec> imports;
        List<String> globals;

        public ParseResult(byte[] filedata, List<JSXParser.ImportSpec> imports, List<String> globals) {
            this.filedata = filedata;
            this.imports = imports;
            this.globals = globals;
        }

        public byte[] getFiledata() {
            return this.filedata;
        }

        public List<JSXParser.ImportSpec> getImports() {
            return this.imports;
        }

        public List<String> getGlobals() {
            return this.globals;
        }
    }
}

