/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.transpiler.jsx;

import org.nustaq.kontraktor.webapp.transpiler.jsx.GenOut;
import org.nustaq.kontraktor.webapp.transpiler.jsx.Inp;

public class JSBeautifier {
    public void parseJS(GenOut cur, Inp in) {
        boolean returnOnLastMatchingBrace;
        boolean bl = returnOnLastMatchingBrace = in.ch() == '{';
        while (in.ch() > '\u0000') {
            char ch = in.ch(0);
            if (ch == '/' && in.ch(1) == '/') {
                cur.print(this.readSlashComment(in));
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                cur.print(this.readJSString(in));
                continue;
            }
            if (ch == '/' && in.ch(1) == '*') {
                cur.print(this.readStarComment(in));
                continue;
            }
            if (ch == '}' || ch == ']' || ch == ')') {
                cur.unindent();
            }
            cur.print(ch);
            if (ch == '{' || ch == '[' || ch == '(') {
                cur.indent();
            }
            in.inc();
        }
    }

    public StringBuilder readSlashComment(Inp in) {
        char c;
        StringBuilder res = new StringBuilder(100);
        while ((c = in.ch(0)) != '\n' && c != '\u0000') {
            res.append(c);
            in.advance(1);
        }
        return res;
    }

    StringBuilder readStarComment(Inp in) {
        char c;
        StringBuilder res = new StringBuilder(100);
        while (((c = in.ch(-2)) != '*' || in.ch(-1) != '/') && c != '\u0000') {
            res.append(c);
            in.advance(1);
        }
        return res;
    }

    StringBuilder readJSString(Inp in) {
        char endChar = in.ch(0);
        StringBuilder res = new StringBuilder(100);
        in.inc();
        res.append(endChar);
        while (in.ch() != endChar && in.ch(0) != '\u0000') {
            res.append(in.ch());
            in.advance(1);
            if (in.ch() != endChar || in.ch(-1) != '\\') continue;
            in.advance(1);
            res.append(in.ch());
        }
        res.append(endChar);
        in.inc();
        return res;
    }
}

