/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.javascript;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nustaq.kontraktor.remoting.http.javascript.TranspileException;
import org.nustaq.kontraktor.remoting.http.javascript.TranspilerHook;
import org.nustaq.kontraktor.util.Log;

public abstract class CLICommandTranspiler
implements TranspilerHook {
    String endingToLookFor;

    public CLICommandTranspiler(String endingToLookFor) {
        this.endingToLookFor = endingToLookFor;
    }

    @Override
    public byte[] transpile(File f) throws TranspileException {
        File dir = f.getParentFile();
        String name = f.getName();
        int idx = name.indexOf(46);
        if (idx <= 0) {
            return null;
        }
        File source = new File(dir, name.substring(0, idx) + this.endingToLookFor);
        if (source.exists() && this.shouldUpdate(f, source)) {
            Process proc;
            ProcessBuilder p = new ProcessBuilder(this.createCMDLine(f, source)).directory(dir);
            try {
                proc = p.start();
            }
            catch (IOException e) {
                throw new TranspileException(e);
            }
            this.ioPoller(System.out, proc.getInputStream(), proc);
            this.ioPoller(System.err, proc.getErrorStream(), proc);
            try {
                int res = proc.waitFor();
                if (res != 0) {
                    throw new TranspileException("transpiler returned " + res + " on " + source.getAbsolutePath());
                }
                Log.Info((Object)this, (String)("success transpiling " + source.getAbsolutePath() + " to " + f.getAbsolutePath()));
            }
            catch (InterruptedException e) {
                throw new TranspileException(e);
            }
        }
        return null;
    }

    protected boolean shouldUpdate(File targetJSFile, File source) {
        return !targetJSFile.exists() || source.lastModified() > targetJSFile.lastModified();
    }

    protected abstract String[] createCMDLine(File var1, File var2);

    public void ioPoller(OutputStream fout, final InputStream in, final Process proc) {
        final OutputStream finalFout = fout;
        new Thread("io poll " + proc){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (proc.isAlive()) {
                            int read = in.read();
                            if (read >= 32 || read == 9 || read == 10 || read == 13) {
                                if (finalFout != null) {
                                    finalFout.write(read);
                                    continue;
                                }
                                System.out.write(read);
                                continue;
                            }
                            if (read < 0) break block4;
                            try {
                                Thread.sleep(1L);
                                continue block4;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        }.start();
    }
}

