/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.undertow.builder;

import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.nustaq.kontraktor.remoting.http.javascript.TranspilerHook;
import org.nustaq.kontraktor.remoting.http.undertow.builder.BldFourK;

public class BldResPath {
    transient BldFourK cfg4k;
    String urlPath = "/dyn";
    String[] resourcePath;
    String baseDir = ".";
    boolean cacheAggregates = true;
    Boolean compress;
    boolean inline = true;
    boolean stripComments = true;
    boolean minify = true;
    transient Map<String, TranspilerHook> transpilers = new HashMap<String, TranspilerHook>();
    Function<HttpServerExchange, Boolean> handlerInterceptor;

    public BldResPath(BldFourK cfg4k, String urlPath) {
        this.cfg4k = cfg4k;
        this.urlPath = urlPath;
    }

    public BldResPath handlerInterceptor(Function<HttpServerExchange, Boolean> handlerInterceptor) {
        this.handlerInterceptor = handlerInterceptor;
        return this;
    }

    public Function<HttpServerExchange, Boolean> getHandlerInterceptor() {
        return this.handlerInterceptor;
    }

    public BldResPath elements(String ... resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public BldResPath inline(boolean inline) {
        this.inline = inline;
        return this;
    }

    public BldResPath stripComments(boolean stripComments) {
        this.stripComments = stripComments;
        return this;
    }

    public BldResPath baseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public BldResPath minify(boolean minify) {
        this.minify = minify;
        return this;
    }

    public boolean isInline() {
        return this.inline;
    }

    public boolean isStripComments() {
        return this.stripComments;
    }

    public boolean isMinify() {
        return this.minify;
    }

    public BldResPath cacheAggregates(boolean cacheAggregates) {
        this.cacheAggregates = cacheAggregates;
        return this;
    }

    public BldResPath allDev(boolean dev) {
        this.inline(!dev);
        this.stripComments(!dev);
        this.minify(!dev);
        this.cacheAggregates(!dev);
        this.compress(!dev);
        return this;
    }

    public BldResPath compress(boolean doGZip) {
        this.compress = doGZip;
        return this;
    }

    public BldFourK build() {
        return this.cfg4k;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public boolean isCacheAggregates() {
        return this.cacheAggregates;
    }

    public String[] getResourcePath() {
        return this.resourcePath;
    }

    public boolean isCompress() {
        if (this.compress == null) {
            return !this.cacheAggregates;
        }
        return this.compress;
    }

    public BldResPath transpile(String ending, TranspilerHook hook) {
        this.transpilers.put(ending, hook);
        return this;
    }

    public Map<String, TranspilerHook> getTranspilers() {
        return this.transpilers;
    }
}

