/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.websockets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ActorClientConnector;
import org.nustaq.kontraktor.remoting.base.ObjectSink;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.kontraktor.remoting.websockets.WebObjectSocket;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.serialization.util.FSTUtil;

public class JSR356ClientConnector
implements ActorClientConnector {
    public static boolean DumpProtocol = false;
    static AtomicReference<RemotingHelper> singleton = new AtomicReference();
    WSClientEndpoint endpoint;
    URI uri;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemotingHelper get() {
        AtomicReference<RemotingHelper> atomicReference = singleton;
        synchronized (atomicReference) {
            if (singleton.get() == null) {
                singleton.set((RemotingHelper)Actors.AsActor(RemotingHelper.class));
            }
            return singleton.get();
        }
    }

    public JSR356ClientConnector(String uri) throws URISyntaxException {
        this.uri = new URI(uri);
    }

    public IPromise connect(Function<ObjectSocket, ObjectSink> factory) throws Exception {
        this.endpoint = new WSClientEndpoint(this.uri, null);
        ObjectSink sink = factory.apply(this.endpoint);
        this.endpoint.setSink(sink);
        return new Promise(null);
    }

    public IPromise closeClient() {
        try {
            this.endpoint.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Promise(null, (Object)e);
        }
        return new Promise(null);
    }

    @ClientEndpoint
    protected static class WSClientEndpoint
    extends WebObjectSocket {
        static AtomicInteger idCount = new AtomicInteger(0);
        int id = idCount.incrementAndGet();
        protected ObjectSink sink;
        protected volatile Session session = null;

        public WSClientEndpoint(URI endpointURI, ObjectSink sink) {
            try {
                WebSocketContainer container = ContainerProvider.getWebSocketContainer();
                container.connectToServer((Object)this, endpointURI);
                this.sink = sink;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public ObjectSink getSink() {
            return this.sink;
        }

        public void setSink(ObjectSink sink) {
            this.sink = sink;
        }

        @OnOpen
        public void onOpen(Session userSession) {
            this.session = userSession;
        }

        @OnClose
        public void onClose(Session userSession, CloseReason reason) {
            this.session = null;
            Log.Info((Object)this, (String)("Connection closed " + reason));
            this.sink.sinkClosed();
        }

        @OnError
        public void onError(Throwable th) {
            Log.Warn((Object)this, (Throwable)th);
        }

        @OnMessage
        public void onMessage(byte[] message) {
            if (DumpProtocol) {
                System.out.println("resp:");
                System.out.println(new String(message, 0));
            }
            this.sink.receiveObject(this.conf.asObject(message), null);
        }

        @OnMessage
        public void onTextMessage(String message) {
            if (DumpProtocol) {
                System.out.println("resp:");
                System.out.println(message);
            }
            this.sink.receiveObject(this.conf.asObject(message.getBytes()), null);
        }

        public void sendText(String message) {
            this.session.getAsyncRemote().sendText(message);
        }

        @Override
        public void sendBinary(byte[] message) {
            if (DumpProtocol) {
                System.out.println("requ:");
                System.out.println(new String(message, 0));
            }
            final Actor executor = Actor.current();
            this.session.getAsyncRemote().sendBinary(ByteBuffer.wrap(message), new SendHandler(){

                public void onResult(SendResult result) {
                    if (!result.isOK()) {
                        executor.execute(() -> {
                            FSTUtil.rethrow((Throwable)result.getException());
                            try {
                                this.close();
                            }
                            catch (IOException e) {
                                Log.Warn((Object)this, (Throwable)e);
                            }
                        });
                    }
                }
            });
        }

        public void close() throws IOException {
            if (this.session != null) {
                this.session.close();
            }
            this.sink.sinkClosed();
        }

        public int getId() {
            return this.id;
        }
    }

    public static class RemotingHelper
    extends Actor<RemotingHelper> {
    }
}

