/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.remoting.base.ActorServer;
import org.nustaq.kontraktor.remoting.http.HttpPublisher;
import org.nustaq.kontraktor.remoting.http.builder.BldFourK;
import org.nustaq.kontraktor.remoting.http.javascript.DynamicResourceManager;
import org.nustaq.kontraktor.remoting.websockets.WebSocketPublisher;
import org.nustaq.kontraktor.util.Pair;

public class Http4K {
    public static int UNDERTOW_IO_THREADS = 8;
    public static int UNDERTOW_WORKER_THREADS = 8;
    protected static Http4K instance;
    protected Map<Integer, Pair<PathHandler, Undertow>> serverMap = new HashMap<Integer, Pair<PathHandler, Undertow>>();

    public static void set(Http4K http) {
        instance = http;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Http4K get() {
        Class<Http4K> clazz = Http4K.class;
        synchronized (Http4K.class) {
            if (instance == null) {
                System.setProperty("org.jboss.logging.provider", "slf4j");
                instance = new Http4K();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static BldFourK Build(String hostName, int port, SSLContext ctx) {
        return Http4K.get().builder(hostName, port, ctx);
    }

    public static BldFourK Build(String hostName, int port) {
        return Http4K.get().builder(hostName, port, null);
    }

    public synchronized Pair<PathHandler, Undertow> getServer(int port, String hostName) {
        return this.getServer(port, hostName, null);
    }

    public synchronized Pair<PathHandler, Undertow> getServer(int port, String hostName, SSLContext context) {
        Pair pair = this.serverMap.get(port);
        if (pair == null) {
            PathHandler pathHandler = new PathHandler();
            Undertow.Builder builder = Undertow.builder().setIoThreads(UNDERTOW_IO_THREADS).setWorkerThreads(UNDERTOW_WORKER_THREADS);
            Undertow server = this.customize(builder, pathHandler, port, hostName, context).build();
            server.start();
            pair = new Pair((Object)pathHandler, (Object)server);
            this.serverMap.put(port, (Pair<PathHandler, Undertow>)pair);
        }
        return pair;
    }

    public BldFourK builder(String hostName, int port, SSLContext ctx) {
        return new BldFourK(hostName, port, ctx);
    }

    public BldFourK builder(String hostName, int port) {
        return new BldFourK(hostName, port, null);
    }

    protected Undertow.Builder customize(Undertow.Builder builder, PathHandler rootPathHandler, int port, String hostName, SSLContext context) {
        if (context == null) {
            return builder.addHttpListener(port, hostName).setHandler((HttpHandler)rootPathHandler);
        }
        return builder.addHttpsListener(port, hostName, context).setHandler((HttpHandler)rootPathHandler);
    }

    public Http4K publishFileSystem(String hostName, String urlPath, int port, File root) {
        if (!root.isDirectory()) {
            throw new RuntimeException("root must be an existing direcory:" + root.getAbsolutePath());
        }
        Pair<PathHandler, Undertow> server = this.getServer(port, hostName);
        ((PathHandler)server.car()).addPrefixPath(urlPath, (HttpHandler)new ResourceHandler((ResourceManager)new FileResourceManager(root, 100L)));
        return this;
    }

    public Http4K publishFileSystem(String hostName, String urlPath, int port, FileResourceManager man) {
        if (!man.getBase().isDirectory()) {
            throw new RuntimeException("root must be an existing direcory:" + man.getBase().getAbsolutePath());
        }
        Pair<PathHandler, Undertow> server = this.getServer(port, hostName);
        ((PathHandler)server.car()).addPrefixPath(urlPath, (HttpHandler)new ResourceHandler((ResourceManager)man));
        return this;
    }

    public Http4K publishResourcePath(String hostName, String urlPath, int port, DynamicResourceManager man, boolean compress) {
        Pair<PathHandler, Undertow> server = this.getServer(port, hostName);
        ResourceHandler handler = new ResourceHandler((ResourceManager)man);
        if (compress) {
            HttpHandler httpHandler = new EncodingHandler.Builder().build(new HashMap()).wrap((HttpHandler)handler);
            ((PathHandler)server.car()).addPrefixPath(urlPath, httpHandler);
        } else {
            ((PathHandler)server.car()).addPrefixPath(urlPath, (HttpHandler)handler);
        }
        return this;
    }

    public IPromise<ActorServer> publish(WebSocketPublisher publisher) {
        return publisher.publish();
    }

    public IPromise<ActorServer> publish(HttpPublisher publisher) {
        return publisher.publish();
    }

    public Http4K publishHandler(String hostName, String urlPath, int port, HttpHandler handler) {
        Pair<PathHandler, Undertow> server = this.getServer(port, hostName);
        ((PathHandler)server.car()).addPrefixPath(urlPath, handler);
        return this;
    }
}

