/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.websockets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.util.FSTUtil;

public abstract class WebObjectSocket
implements ObjectSocket {
    protected List objects;
    protected FSTConfiguration conf;
    protected Throwable lastError;
    protected AtomicInteger sendSequence = new AtomicInteger(0);
    protected volatile boolean isClosed;

    public AtomicInteger getSendSequence() {
        return this.sendSequence;
    }

    public WebObjectSocket() {
        this.objects = new ArrayList();
    }

    public void writeObject(Object toWrite) throws Exception {
        this.objects.add(toWrite);
        if (this.objects.size() > this.getObjectMaxBatchSize()) {
            this.flush();
        }
    }

    protected int getObjectMaxBatchSize() {
        return 100;
    }

    public abstract void sendBinary(byte[] var1);

    public void flush() throws Exception {
        if (this.objects.size() == 0) {
            return;
        }
        if (this.isClosed()) {
            if (this.lastError != null) {
                FSTUtil.rethrow((Throwable)this.lastError);
            } else {
                throw new IOException("WebSocket is closed");
            }
        }
        this.objects.add(this.sendSequence.incrementAndGet());
        Object[] objArr = this.objects.toArray();
        this.objects.clear();
        this.sendBinary(this.conf.asByteArray((Object)objArr));
    }

    public void setLastError(Throwable ex) {
        this.lastError = ex;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void setConf(FSTConfiguration conf) {
        this.conf = conf;
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

